/*****************************************************************************

 @(#) $Id: debug.h,v 0.7.4.2 2001/02/18 09:44:11 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:11 $ by $Author: brian $

 *****************************************************************************/

#ifndef __DEBUG_H__
#define __DEBUG_H__

#define DDTRACE          do { printk("%s [%s %d] trace\n",__FUNCTION__,__FILE__, __LINE__); } while(0)
#define DDPRINT(n,args)  do { printk args; } while(0)

#ifdef  _DEBUG
#define DTRACE           do { if ( DEBUG_LEVEL ) { printk("%s [%s %d] trace\n",__FUNCTION__,__FILE__, __LINE__); } } while(0)
#define DPRINT(n,args)   do { if (DEBUG_LEVEL>n) { printk args; } } while(0)
#define DBLOCK(n,block)     { if (DEBUG_LEVEL>n) { block } }
#else
#define DTRACE    
#define DPRINT(n,args)
#define DBLOCK(n,block)
#endif

#endif  __DEBUG_H__
