/*****************************************************************************

 @(#) $Id: dev.h,v 0.7.4.2 2001/02/18 09:44:13 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:13 $ by $Author: brian $

 *****************************************************************************/

#ifndef __DEVI_DEV_H__
#define __DEVI_DEV_H__

#ifdef  __KERNEL__

struct dev;
struct sdl;

typedef struct dev_ucalls {
    void (*daedr_recvd_frame  )(struct dev *, mblk_t *);
    void (*daedr_compr_frame  )(struct dev *, int);
    void (*daedr_error_frame  )(struct dev *);
    void (*daedr_loss_of_sync )(struct dev *);
    void (*daedr_N_octets     )(struct dev *);
    void (*daedt_tx_request   )(struct dev *);
} dev_ucalls_t;

typedef struct dev_dcalls {
    void (*xmit    )(struct dev *, mblk_t *);
    void (*rx_start)(struct dev *);
    void (*tx_start)(struct dev *);
} dev_dcalls_t;

struct dev {
    struct dev          *next;
    struct sdl          *module;
    struct dev_ucalls   *ucalls;
    dev_device_t        iface;
};


#endif  /* __KERNEL__ */

#endif  __DEVI_DEV_H__
