/*****************************************************************************

 @(#) $Id: lk.h,v 0.7.4.1 2001/02/18 09:44:16 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:16 $ by $Author: brian $

 *****************************************************************************/

#ifndef __LK_H__
#define __LK_H__

#ifdef __KERNEL__

struct lk;

typedef struct lk_ucalls {
    void (*lk_signal_unit)(struct lk *, int, mblk_t *);
    void (*lk_failure    )(struct lk *, int);
    void (*lk_restored   )(struct lk *);
    void (*lk_inhibited  )(struct lk *);
    void (*lk_congested  )(struct lk *);
} lk_ucalls_t;

typedef struct lk_dcalls {
    void (*lk_signal_unit)(struct lk *, int, mblk_t *);
    void (*lk_stop       )(struct lk *);
    void (*lk_start      )(struct lk *);
    void (*lk_restart    )(struct lk *);
    void (*lk_inhibit    )(struct lk *);
    void (*lk_unihibit   )(struct lk *);
} lk_dcalls_t;

typedef struct lk_mcalls {
    void (*sl_pdu       )(struct lk*, mblk_t *);
    void (*sl_emerg     )(struct lk*);
    void (*sl_normal    )(struct lk*);
    void (*sl_start     )(struct lk*);
    void (*sl_stop      )(struct lk*);
    void (*sl_bsnt      )(struct lk*);
    void (*sl_fsnc      )(struct lk*, int);
    void (*sl_resume    )(struct lk*);
    void (*sl_clear_bufs)(struct lk*);
    void (*sl_lpo       )(struct lk*);
    void (*sl_cg_accept )(struct lk*);
    void (*sl_cg_discard)(struct lk*);
    void (*sl_no_cong   )(struct lk*);
    void (*sl_power_on  )(struct lk*);
} lk_mcalls_t;

typedef struct lk_driver {
    struct lk_driver *next;
    int              cmajor;
    int              cminor;
    struct lk        *list;
    struct streamtab *info;
    struct lmi_ops   ops;
    struct sl_dcalls *dcalls;
    struct sl_ucalls *ucalls;
} lk_driver_t;

typedef lmi_option_t lk_option_t;

typedef struct lk_timers {
} lk_timers_t;

#define LK_MAX_TIMERIDS 7
#define LK_MAX_BUFCALLS 8

typedef lk_ulong lk_bufcid_t[LK_MAX_BUFCALLS];

typedef struct lk {
    struct lk           *next;
    struct ls           *module;
    struct lk_ucalls    *ucalls;
    struct lk_mcalls    *dcalls;
    struct sl           *device;
    lk_driver_t         *driver;
    dev_t               devnum;
    queue_t             *rq;
    queue_t             *wq;
    lk_ulong            state;
    lk_ulong            flags;
    lk_ulong            ids[0];
    lk_timers_t         timers;     /* LK protocol timers               */
    lk_bufcid_t         bufids;     /* LK protocol buffer calls         */
    lk_option_t         option;     /* LK protocol variant and options  */
    lk_config_t         config;     /* LK protocol configuration        */
    lk_statem_t         statem;     /* LK protocol state variables      */
    lk_stats_t          stats;      /* LK protocol statistics           */
    lk_notify_t         notify;     /* LK protocol events               */
} lk_t;

#endif /* __KERNEL__ */

#endif  __LK_H__

