/*****************************************************************************

 @(#) $Id: mtp.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTPI_MTP_H__
#define __MTPI_MTP_H__

#ifdef __KERNEL__

/* multiplexor lower stream definitions (per link set) */

struct mtpl;
struct mtp;

typedef struct mtpl_ucalls {
    void (*rt_signal_unit   )(struct mtpl *, mblk_t *, int, int);
    void (*rt_prohibited    )(struct mtpl *);
    void (*rt_allowed       )(struct mtpl *);
    void (*rt_restricted    )(struct mtpl *);
    void (*rt_congested     )(struct mtpl *, int, int);
    void (*rt_restart_ends  )(struct mtpl *);
} mtpl_ucalls_t;

typedef struct mtpl_dcalls {
    void (*ls_signal_unit       )(struct mtpl *, int, mblk_t *);
    void (*ls_stop              )(struct mtpl *);
    void (*ls_start             )(struct mtpl *);
    void (*ls_restart           )(struct mtpl *);
    void (*ls_inhibit           )(struct mtpl *);
    void (*ls_uninhibit         )(struct mtpl *);
} mtpl_dcalls_t;

typedef struct mtpl_mcalls {
    void (*ls_signal_unit       )(struct mtpl *, int, mblk_t *);
    void (*ls_stop              )(struct mtpl *);
    void (*ls_start             )(struct mtpl *);
    void (*ls_restart           )(struct mtpl *);
    void (*ls_inhibit           )(struct mtpl *);
    void (*ls_uninhibit         )(struct mtpl *);
} mtpl_mcalls_t;

typedef struct mtpl_driver {
    struct mtpl_driver  *next;
    int                 cmajor;
    int                 nminor;
    struct mtpl         *list;
    struct streamtab    *info;
    struct lmi_ops      ops;
    struct sls_dcalls   *dcalls;
    struct sls_ucalls   *ucalls;
} mtpl_driver_t;

typedef lmi_option_t mtpl_option_t;

typedef struct mtpl_timers {
} mtpl_timers_t;

#define MTPL_MAX_TIMERIDS 0
#define MTPL_MAX_BUFCALLS 8

typedef mtp_ulong mtpl_bufcid_t[MTPL_MAX_BUFCALLS];

typedef struct mtpl {
    struct mtpl         *next;      /* next stream in list                  */
    struct mtp          *module;    /* MTP upper mux                        */
    struct mtpl_ucalls  *ucalls;    /* MTP upper mux calls                  */
    struct mtpl_mcalls  *dcalls;    /* SLS device calls                     */
    struct sls          *device;    /* SLS device                           */
    mtpl_driver_t       *driver;    /* MTP-SLS driver                       */
    int                 muxid;      /* MTP lower mux id                     */
    queue_t             *rq;        /* MTP lower read  queue                */
    queue_t             *wq;        /* MTP lower write queue                */
    mtp_ulong           state;      /* MTP-SLS interface state              */
    mtp_ulong           flags;      /* MTP-SLS interface flags              */
    mtp_ulong           ids[0];
    mtpl_timers_t       timers;     /* MTP-SLS protocol timers              */
    mtpl_bufcid_t       bufids;     /* MTP-SLS protocol buffer calls        */
    mtpl_option_t       option;     /* MTP-SLS protocol variant and options */
    mtp_config_t       config;     /* MTP-SLS protocol configuration       */
    mtp_statem_t       statem;     /* MTP-SLS protocol state variables     */
    mtp_stats_t        stats;      /* MTP-SLS protocol statistics          */
    mtp_notify_t       notify;     /* MTP-SLS protocol events              */
} mtpl_t;

/* multiplexor upper stream definitions (per signalling point) */

struct musr;

typedef struct mtp_ucalls {
    void (*mtp_transfer     )(struct mtp *, mblk_t *, int, int, int);
    void (*mtp_pause        )(struct mtp *, int);
    void (*mtp_resume       )(struct mtp *, int);
    void (*mtp_status       )(struct mtp *, int, int);
    void (*mtp_restart_ends )(struct mtp *);
} mtp_ucalls_t;

typedef struct mtp_dcalls {
    void (*rs_signal_unit   )(struct mtp *, mblk_t *, int, int);
} mtp_dcalls_t;

typedef struct mtp_mcalls {
    void (*ls_signal_unit       )(struct mtp *, int, mblk_t *);
    void (*ls_stop              )(struct mtp *);
    void (*ls_start             )(struct mtp *);
    void (*ls_restart           )(struct mtp *);
    void (*ls_inhibit           )(struct mtp *);
    void (*ls_uninhibit         )(struct mtp *);
} mtp_mcalls_t;

typedef struct mtp_driver {
    struct mtp_driver   *next;
    int                 cmajor;
    int                 nminor;
    struct mtp          *list;
    struct streamtab    *info;
    struct lmi_ops      ops;
    struct mtpl_dcalls  *dcalls;
    struct mtpl_ucalls  *ucalls;
} mtp_driver_t;

typedef lmi_option_t mtp_option_t;

typedef struct mtp_timers {
} mtp_timers_t;

#define MTP_MAX_TIMERIDS 0
#define MTP_MAX_BUFCALLS 8

typedef mtp_ulong mtp_bufcid_t[MTP_MAX_BUFCALLS];

typedef struct mtp {
    struct mtp          *next;      /* next stream in list                  */
    struct musr         *module;    /* MTP USER module                      */
    struct mtp_ucalls   *ucalls;    /* MTP USER calls                       */
    struct mtp_mcalls   *dcalls;
    struct mtpl         *device;
    mtp_driver_t        *driver;
    dev_t               devnum;
    queue_t             *rq;
    queue_t             *wq;
    mtp_ulong           state;
    mtp_ulong           flags;
    mtp_ulong           ids[0];
    mtp_timers_t        timers;
    mtp_bufcid_t        bufids;
    mtp_option_t        option;
    mtp_config_t        config;
    mtp_statem_t        statem;
    mtp_stats_t         stats;
    mtp_notify_t        notify;
} mtp_t;

#endif  /* __KERNEL__ */

#endif  __MTPI_MTP_H__
