/*****************************************************************************

 @(#) $Id: mtp_hmcg.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_HMCG_H__
#define __MTP_HMCG_H__

/*
 *  Reference functions.
 */

static inline void rs_rtcc_send_transfer_controlled_message(rs_t *rs, mblk_t *mp);

static inline void rt_l2_message_for_transmission(rt_t *rt, mblk_t *mp);

/*
 *  Forward declarations.
 */

static inline void rt_hmcg_message(rt_t *rt, mblk_t *mp);

/*
 *  Signalling Message Handling (SMH)
 *  Signalling Link Congestion (HMCG)
 *  Figure 26a/Q.704
 */

/*
 *  Another ridiculous state machine with no states.
 */

static inline void rt_hmcg_message(rt_t *rt, mblk_t *mp)
{
    rs_t *rs = rt->module;
//  switch ( rs->statem.hmcg_state ) {
//      case MTP_STATE_IDLE:
            if ( P < rs->statem.cong_level ) {
                /* P is message priority, the congestion status is updated by
                 * an implementation dependent procedure in conformance to 3.8
                 */
                rs_rtcc_send_transfer_controlled_message(rs, mp);
                if ( P < rs->statem.disc_level ) {
                    /* The discard status is updated by an implementation
                     * dependent procedure in conformance to 3.8
                     */
                    freemsg(mp);
                    return;
                }
            }
            rt_hmrt_hmdc_message_for_routing(rt, mp);
//          rs_l2_message_for_transmission(rs, mp); /* to selected link */
//          break;
//  }
}


#endif  __MTP_HMCG_H__

