/*****************************************************************************

 @(#) $Id: mtp_hmdc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_HMDC_H__
#define __MTP_HMDC_H__

/*
 *  Referenced functions.
 */

static inline void mtp_hmdt_message_for_distribution(mtp_t *mtp);

static inline void mtp_hmrt_message_for_routing(mtp_t *mtp);

/*
 *  Forward declarations.
 */

static inline void mtp_hmdc_received_message(mtp_t *mtp);
static inline void mtp_hmdc_restart_begins(mtp_t *mtp);
static inline void mtp_hmdc_restart_ends(mtp_t *mtp);

/*
 *  Signalling Message Handling (SMH)
 *  Message Discrimination (HMDC)
 *  Figure 24/Q.704
 *  Figure 24/T1.111.4
 */

/*
 *  Another useless state machine.
 */

static inline void mtp_hmdc_received_message(mtp_t *mtp) /* from L2 */
{
//  switch ( mtp->statem.hmdc_state ) {
//      case MTP_STATE_IDLE:
            /* Determine label structure (from network indicator) */
            if ( /* destined to this sp? */ )
                /* This is determined from the DPC for regular messages and
                 * from the Service Indicator for certain Special Test
                 * Messages */
            {
                mtp_hmdt_message_for_distribution(mtp);
            }
            else
            {
                if ( mtp->statem.own_sp_restart ) {
                    /* discard message */
                } else {
                    mtp_hmrt_message_for_routing(mtp);
                }
            }
//          break;
//  }
}

#if 1   /* ITU only: ANSI doesn't do it this way. */
static inline void mtp_hmdc_restart_begins(mtp_t *mtp)
{
//  switch ( mtp->statem.hmdc_state ) {
//      case MTP_STATE_IDLE:
            mtp->statem.own_sp_restart = 1;
//          break;
//  }
}

static inline void mtp_hmdc_restart_ends(mtp_t *mtp)
{
//  switch ( mtp->statem.hmdc_state ) {
//      case MTP_STATE_IDLE:
            mtp->statem.own_sp_restart = 0;
//          break;
//  }
}
#endif

#endif  __MTP_HMDC_H__

