/*****************************************************************************

 @(#) $Id: mtp_hmdt.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_HMDT_H__
#define __MTP_HMDT_H__

/*
 *  Referenced functions.
 */

static inline void mtp_hmrt_user_part_unavailable(mtp_t *mtp);

static inline void mtp_l4_transfer_indication(mtp_t *mtp);

static inline void mtp_slm_signalling_link_management_message(mtp_t *mtp);

static inline void mtp_sltc_signalling_link_test_control_message(mtp_t *mtp);

static inline void mtp_srm_signalling_route_management_message(mtp_t *mtp);

static inline void mtp_ssltc_special_signalling_link_test_control_message(mtp_t *mtp);

static inline void mtp_stm_signalling_route_management_message(mtp_t *mtp);
static inline void mtp_stm_signalling_traffic_management_message(mtp_t *mtp);

/*
 *  Forward declarations.
 */

static inline void mtp_hmdt_message_for_distribution(mtp_t *mp);
static inline void mtp_hmdt_restart_begins(mtp_t *mp);

/*
 *  Signalling Message Handling (SMH)
 *  Message Distribution (HMDT)
 *  Figure 25/Q.704
 */

/*
 *  Another useless state machine.  This can (and should) be rearranged to be
 *  a stateless state machine with an "Own SP Restart" flag.
 */

static inline void mtp_hmdt_message_for_distribution(mtp_t *mp)
{
    switch ( mtp->statem.hmdt_state ) {
        case MTP_STATE_IDLE:
            switch ( service_indicator ) {
                case MTP_SI_SNM:
                    switch ( message_type ) {
                        case MTP_MT_SRM:
                            /* we should break these out */
                            mtp_srm_signalling_route_management_message(mtp);
                            break;
                        case MTP_MT_SLM:
                            /* we should break these out */
                            mtp_slm_signalling_link_management_message(mtp);
                            break;
                        case MTP_MT_STM:
                            /* we should break these out */
                            mtp_stm_signalling_traffic_management_message(mtp);
                            break;
                        default:
                            /* discard message */
                            break;
                    }
                    break;
                case MTP_SI_SLTC:
                    /* we should break these out */
                    mtp_sltc_signalling_link_test_control_message(mtp);
                    break;
                case MTP_SI_SSLTC:
                    /* we should break these out */
                    mtp_ssltc_special_signalling_link_test_control_message(mtp);
                    break;
                default:
                    if ( mtp->statem.user_part_available[service_indicator] ) {
                        /* we should break these out */
                        mtp_l4_transfer_indication(mtp);
                    } else {
                        /* discard message */
                        mtp_hmrt_user_part_unavailable(mtp);
                    }
                    break;
            }
            break;
        case MTP_STATE_OWN_SP_RESTART:
            switch ( service_indicator ) {
                case MTP_SI_SNM:
                    switch ( message_type ) {
                        case MTP_MT_SRM:
                            switch ( message ) {
                                case MTP_SRM_TFP:
                                case MTP_SRM_TFR:
                                case MTP_SRM_TFA:
                                    mtp_srm_signalling_route_management_message(mtp);
                                    break;
                                default:
                                    /* discard message */
                                    break;
                            }
                            break;
                        case MTP_MT_STM:
                            switch ( message ) {
                                case MTP_STM_TRA:
                                    mtp_stm_signalling_route_management_message(mtp);
                                    break;
                                default:
                                    /* discard message */
                                    break;
                            }
                            break;
                        default:
                            /* discard message */
                            break;
                    }
                    break;
                case MTP_SI_SLTC:
                    /* we should break these out */
                    mtp_sltc_signalling_link_test_control_message(mtp);
                    break;
                case MTP_SI_SSLTC:
                    /* we should break these out */
                    mtp_ssltc_special_signalling_link_test_control_message(mtp);
                    break;
                default:
                    /* discard message */
                    break;
            }
            break;
    }
}

#if 1 /* ITU only; ANSI doesn't do it this way. */
static inline void mtp_hmdt_restart_begins(mtp_t *mp)
{
    switch ( mtp->statem.hmdt_state ) {
        case MTP_STATE_IDLE:
            mtp->statem.hmdt_state = RS_STATE_OWN_SP_RESTART;
            break;
    }
}
#endif

#endif  __MTP_HMDT_H__

