/*****************************************************************************

 @(#) $Id: mtp_parse.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SS7MTP_PARSE_H__
#define __SS7MTP_PARSE_H__

/*
 *  This is just a parsing support file for SS7 MTP messages.  It contains
 *  "C" language routines to unpack each of the SS7 MTP messages into an
 *  unpacked structure and routines to pack them back in.  All functions
 *  are static and inline and will only be compiled if needed.
 */

#define SS7_SIF_MAX 272

#define SS7_MTP_VARIANT_ITU  1
#define SS7_MTP_VARIANT_ANSI 2

struct __ansi_pc {
    unsigned network   __attribute__ ((packed));
    unsigned cluster   __attribute__ ((packed));
    unsigned member    __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_rl {
    unsigned dpc:24    __attribute__ ((packed));
    unsigned opc:24    __attribute__ ((packed));
    unsigned sls0:3    __attribute__ ((packed));
    unsigned sls:5     __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_mtph {
    unsigned si:4      __attribute__ ((packed));
    unsigned mp:2      __attribute__ ((packed));
    unsigned ni:2      __attribute__ ((packed));
    struct __ansi_rl rl __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_mtpm {
    unsigned si:4      __attribute__ ((packed));
    unsigned mp:2      __attribute__ ((packed));
    unsigned ni:2      __attribute__ ((packed));
    struct __ansi_rl rl __attribute__ ((packed));
    unsigned h0:4      __attribute__ ((packed));
    unsigned h1:4      __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_pc {
    unsigned network:4 __attribute__ ((packed));
    unsigned cluster:6 __attribute__ ((packed));
    unsigned member:4  __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_rl {
    unsigned dpc:14    __attribute__ ((packed));
    unsigned opc:14    __attribute__ ((packed));
    unsigned sls:4     __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_mtph {
    unsigned si:4      __attribute__ ((packed));
    unsigned mp:2      __attribute__ ((packed));
    unsigned ni:2      __attribute__ ((packed));
    struct __itu_rl rl __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_mtpm {
    unsigned si:4      __attribute__ ((packed));
    unsigned mp:2      __attribute__ ((packed));
    unsigned ni:2      __attribute__ ((packed));
    struct __itu_rl rl __attribute__ ((packed));
    unsigned h0:4      __attribute__ ((packed));
    unsigned h1:4      __attribute__ ((packed));
}__attribute__ ((packed));


struct __ansi_up {
    unsigned char pdu[1] __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_up {
    unsigned char pdu[1] __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_sltc {
    unsigned slc:4     __attribute__ ((packed));
    unsigned tli:4     __attribute__ ((packed));
    unsigned char tmsx[15]  __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_sltc {
    unsigned tli0:4    __attribute__ ((packed));
    unsigned tli:4     __attribute__ ((packed));
    unsigned char tmsx[15]  __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_cbm {
    unsigned slc:4     __attribute__ ((packed));
    unsigned cbc:8     __attribute__ ((packed));
    unsigned cbc0:4    __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_cbm {
    unsigned cbc:8     __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_com {
    unsigned slc:4     __attribute__ ((packed));
    unsigned fsnl:7    __attribute__ ((packed));
    unsigned fsnl0:5   __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_com {
    unsigned fsnl:7    __attribute__ ((packed));
    unsigned fsnl0:1   __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_slm {
    unsigned slc:4     __attribute__ ((packed));
    unsigned slc0:4    __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_slm {
}__attribute__ ((packed));

struct __ansi_tfc {
    unsigned dest:24   __attribute__ ((packed));
    unsigned stat:2    __attribute__ ((packed));
    unsigned stat0:6   __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_tfc {
    unsigned dest:14   __attribute__ ((packed));
    unsigned stat:2    __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_tfm {
    unsigned dest:14   __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_tfm {
    unsigned dest:14   __attribute__ ((packed));
    unsigned dest0:2   __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_ufc {
    unsigned dest:14   __attribute__ ((packed));
    unsigned upi:4     __attribute__ ((packed));
    unsigned upi0:4    __attribute__ ((packed));
}__attribute__ ((packed));

struct __itu_ufc {
    unsigned dest:14   __attribute__ ((packed));
    unsigned dest0:2   __attribute__ ((packed));
    unsigned upi:4     __attribute__ ((packed));
    unsigned upi0:4    __attribute__ ((packed));
}__attribute__ ((packed));

struct __ansi_dlc {
    unsigned slc:4     __attribute__ ((packed));
    unsigned sdli:14  __attribute__ ((packed));
    unsigned sdli0:6   __attribute__ ((packed));

}__attribute__ ((packed));

struct __itu_dlc {
    unsigned sdli:14  __attribute__ ((packed));
    unsigned sdli0:2   __attribute__ ((packed));
}__attribute__ ((packed));

typedef struct __ansi_cbm  __ansi_cba;
typedef struct __ansi_cbm  __ansi_cbd;
typedef struct {         } __ansi_cnp;
typedef struct {         } __ansi_cns;
typedef struct __ansi_com  __ansi_coa;
typedef struct __ansi_com  __ansi_coo;
typedef struct {         } __ansi_css;
typedef struct __ansi_dlc  __ansi_dlc;
typedef struct __ansi_slm  __ansi_eca;
typedef struct __ansi_slm  __ansi_eco;
typedef struct {         } __ansi_lfu;
typedef struct {         } __ansi_lia;
typedef struct {         } __ansi_lid;
typedef struct {         } __ansi_lin;
typedef struct {         } __ansi_lli;
typedef struct {         } __ansi_lri;
typedef struct {         } __ansi_lua;
typedef struct {         } __ansi_lun;
typedef struct __ansi_tfm  __ansi_rcp;
typedef struct __ansi_tfm  __ansi_rcr;
typedef struct {         } __ansi_rct;
typedef struct __ansi_tfm  __ansi_rsp;
typedef struct __ansi_tfm  __ansi_rsr;
typedef struct __ansi_sltc __ansi_slta;
typedef struct __ansi_sltc __ansi_sltm;
typedef struct __ansi_sltc __ansi_sslta;
typedef struct __ansi_sltc __ansi_ssltm;
typedef struct __ansi_tfm  __ansi_tca;
typedef struct __ansi_tfm  __ansi_tcp;
typedef struct __ansi_tfm  __ansi_tcr;
typedef struct __ansi_tfm  __ansi_tfa;
typedef struct __ansi_tfc  __ansi_tfc;
typedef struct __ansi_tfm  __ansi_tfp;
typedef struct __ansi_tfm  __ansi_tfr;
typedef struct {         } __ansi_tra;
typedef struct {         } __ansi_trw;
typedef struct __ansi_ufc  __ansi_upa;
typedef struct __ansi_ufc  __ansi_upt;
typedef struct __ansi_ufc  __ansi_upu;
typedef struct __ansi_up   __ansi_dup1;
typedef struct __ansi_up   __ansi_dup2;
typedef struct __ansi_up   __ansi_isup;
typedef struct __ansi_up   __ansi_mtup;
typedef struct __ansi_up   __ansi_sccp;
typedef struct __ansi_up   __ansi_tup;
typedef struct __ansi_up   __ansi_tupe;
typedef struct __ansi_up   __ansi_tupp;
typedef struct __ansi_up   __ansi_up;

typedef struct __itu_cbm  __itu_cba;
typedef struct __itu_cbm  __itu_cbd;
typedef struct {        } __itu_cnp;
typedef struct {        } __itu_cns;
typedef struct __itu_com  __itu_coa;
typedef struct __itu_com  __itu_coo;
typedef struct {        } __itu_css;
typedef struct __itu_dlc  __itu_dlc;
typedef struct __itu_slm  __itu_eca;
typedef struct __itu_slm  __itu_eco;
typedef struct {        } __itu_lfu;
typedef struct {        } __itu_lia;
typedef struct {        } __itu_lid;
typedef struct {        } __itu_lin;
typedef struct {        } __itu_lli;
typedef struct {        } __itu_lri;
typedef struct {        } __itu_lua;
typedef struct {        } __itu_lun;
typedef struct __itu_tfm  __itu_rcp;
typedef struct __itu_tfm  __itu_rcr;
typedef struct {        } __itu_rct;
typedef struct __itu_tfm  __itu_rsp;
typedef struct __itu_tfm  __itu_rsr;
typedef struct __itu_sltc __itu_slta;
typedef struct __itu_sltc __itu_sltm;
typedef struct __itu_sltc __itu_sslta;
typedef struct __itu_sltc __itu_ssltm;
typedef struct __itu_tfm  __itu_tca;
typedef struct __itu_tfm  __itu_tcp;
typedef struct __itu_tfm  __itu_tcr;
typedef struct __itu_tfm  __itu_tfa;
typedef struct __itu_tfc  __itu_tfc;
typedef struct __itu_tfm  __itu_tfp;
typedef struct __itu_tfm  __itu_tfr;
typedef struct {        } __itu_tra;
typedef struct {        } __itu_trw;
typedef struct __itu_ufc  __itu_upa;
typedef struct __itu_ufc  __itu_upt;
typedef struct __itu_ufc  __itu_upu;
typedef struct __itu_up   __itu_dup1;
typedef struct __itu_up   __itu_dup2;
typedef struct __itu_up   __itu_isup;
typedef struct __itu_up   __itu_mtup;
typedef struct __itu_up   __itu_sccp;
typedef struct __itu_up   __itu_tup;
typedef struct __itu_up   __itu_tupe;
typedef struct __itu_up   __itu_tupp;
typedef struct __itu_up   __itu_up;

union _ss7mtp_msg {
    struct {
        struct __itu_mtpm mh __attribute__ ((packed));
        union {
            __itu_cba cba __attribute__ ((packed));
            __itu_cbd cbd __attribute__ ((packed));
            __itu_cnp cnp __attribute__ ((packed));
            __itu_cns cns __attribute__ ((packed));
            __itu_coa coa __attribute__ ((packed));
            __itu_coo coo __attribute__ ((packed));
            __itu_css css __attribute__ ((packed));
            __itu_dlc dlc __attribute__ ((packed));
            __itu_eca eca __attribute__ ((packed));
            __itu_eco eco __attribute__ ((packed));
            __itu_lfu lfu __attribute__ ((packed));
            __itu_lia lia __attribute__ ((packed));
            __itu_lid lid __attribute__ ((packed));
            __itu_lin lin __attribute__ ((packed));
            __itu_lli lli __attribute__ ((packed));
            __itu_lri lri __attribute__ ((packed));
            __itu_lua lua __attribute__ ((packed));
            __itu_lun lun __attribute__ ((packed));
            __itu_rcp rcp __attribute__ ((packed));
            __itu_rcr rcr __attribute__ ((packed));
            __itu_rct rct __attribute__ ((packed));
            __itu_rsp rsp __attribute__ ((packed));
            __itu_rsr rsr __attribute__ ((packed));
            __itu_slta slta __attribute__ ((packed));
            __itu_sltm sltm __attribute__ ((packed));
            __itu_sslta sslta __attribute__ ((packed));
            __itu_ssltm ssltm __attribute__ ((packed));
            __itu_tca tca __attribute__ ((packed));
            __itu_tcp tcp __attribute__ ((packed));
            __itu_tcr tcr __attribute__ ((packed));
            __itu_tfa tfa __attribute__ ((packed));
            __itu_tfc tfc __attribute__ ((packed));
            __itu_tfp tfp __attribute__ ((packed));
            __itu_tfr tfr __attribute__ ((packed));
            __itu_tra tra __attribute__ ((packed));
            __itu_trw trw __attribute__ ((packed));
            __itu_upa upa __attribute__ ((packed));
            __itu_upt upt __attribute__ ((packed));
            __itu_upu upu __attribute__ ((packed));
            __itu_dup1 dup1 __attribute__ ((packed));
            __itu_dup2 dup2 __attribute__ ((packed));
            __itu_isup isup __attribute__ ((packed));
            __itu_mtup mtup __attribute__ ((packed));
            __itu_sccp sccp __attribute__ ((packed));
            __itu_tup tup __attribute__ ((packed));
            __itu_tupe tupe __attribute__ ((packed));
            __itu_tupp tupp __attribute__ ((packed));
            __itu_up up __attribute__ ((packed));
        } msg __attribute__ ((packed));
    } itu __attribute__ ((packed));
    struct {
        struct __ansi_mtpm mh __attribute__ ((packed));
        union {
            __ansi_cba cba __attribute__ ((packed));
            __ansi_cbd cbd __attribute__ ((packed));
            __ansi_cnp cnp __attribute__ ((packed));
            __ansi_cns cns __attribute__ ((packed));
            __ansi_coa coa __attribute__ ((packed));
            __ansi_coo coo __attribute__ ((packed));
            __ansi_css css __attribute__ ((packed));
            __ansi_dlc dlc __attribute__ ((packed));
            __ansi_eca eca __attribute__ ((packed));
            __ansi_eco eco __attribute__ ((packed));
            __ansi_lfu lfu __attribute__ ((packed));
            __ansi_lia lia __attribute__ ((packed));
            __ansi_lid lid __attribute__ ((packed));
            __ansi_lin lin __attribute__ ((packed));
            __ansi_lli lli __attribute__ ((packed));
            __ansi_lri lri __attribute__ ((packed));
            __ansi_lua lua __attribute__ ((packed));
            __ansi_lun lun __attribute__ ((packed));
            __ansi_rcp rcp __attribute__ ((packed));
            __ansi_rcr rcr __attribute__ ((packed));
            __ansi_rct rct __attribute__ ((packed));
            __ansi_rsp rsp __attribute__ ((packed));
            __ansi_rsr rsr __attribute__ ((packed));
            __ansi_slta slta __attribute__ ((packed));
            __ansi_sltm sltm __attribute__ ((packed));
            __ansi_sslta sslta __attribute__ ((packed));
            __ansi_ssltm ssltm __attribute__ ((packed));
            __ansi_tca tca __attribute__ ((packed));
            __ansi_tcp tcp __attribute__ ((packed));
            __ansi_tcr tcr __attribute__ ((packed));
            __ansi_tfa tfa __attribute__ ((packed));
            __ansi_tfc tfc __attribute__ ((packed));
            __ansi_tfp tfp __attribute__ ((packed));
            __ansi_tfr tfr __attribute__ ((packed));
            __ansi_tra tra __attribute__ ((packed));
            __ansi_trw trw __attribute__ ((packed));
            __ansi_upa upa __attribute__ ((packed));
            __ansi_upt upt __attribute__ ((packed));
            __ansi_upu upu __attribute__ ((packed));
            __ansi_dup1 dup1 __attribute__ ((packed));
            __ansi_dup2 dup2 __attribute__ ((packed));
            __ansi_isup isup __attribute__ ((packed));
            __ansi_mtup mtup __attribute__ ((packed));
            __ansi_sccp sccp __attribute__ ((packed));
            __ansi_tup tup __attribute__ ((packed));
            __ansi_tupe tupe __attribute__ ((packed));
            __ansi_tupp tupp __attribute__ ((packed));
            __ansi_up up __attribute__ ((packed));
        } msg __attribute__ ((packed));
    } ansi __attribute__ ((packed));
} __attribute__ ((packed));

typedef union _ss7mtp_msg ss7mtp_msg;

















#endif  __SS7MTP_PARSE_H__
