/*****************************************************************************

 @(#) $Id: mtp_rcat.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_RCAT_H__
#define __MTP_RCAT_H__

/*
 *  Referenced functions.
 */

static inline void rs_hmrt_signalling_route_set_congestion_test(rs_t *rs);

static inline void rs_trcc_decrement_destination_congestion_status(rs_t *rs);

/*
 *  Forward declarations.
 */

static inline void rs_t16_timeout(rs_t *rs);

static inline void rs_rcat_signalling_route_set_congestion_test(rs_t *rs);
static inline void rs_rcat_start_congestion_test(rs_t *rs);
static inline void rs_rcat_stop_congestion_test(rs_t *rs);

/*
 *  Signalling Route Management (SRM)
 *  Signalling-Route-Set-Congestion-Test Control (RCAT)
 *  Figure 46b/Q.704
 */

#if national_option
static inline void rs_t16_timeout(rs_t *rs)
{
    switch ( rs->statem.rcat_state ) {
        case RS_STATE_WAIT:
            rs_trcc_decrement_destination_congestion_status(rs);
            rs->statem.rcat_state = RS_STATE_IDLE;
            break;
    }
}

static inline void rs_rcat_start_congestion_test(rs_t *rs)
{
    switch ( rs->statem.rcat_state ) {
        case RS_STATE_IDLE:
            rs_hmrt_signalling_route_set_congestion_test(rs); /* to remote L3 */
            rs_timer_start(t16);
            rs->statem.rcat_state = RS_STATE_WAIT;
            break;
    }
}

static inline void rs_rcat_signalling_route_set_congestion_test(rs_t *rs) /* from remote L3 */
{
    switch ( rs->statem.rcat_state ) {
        case RS_STATE_IDLE:
            /* discard message */
            break;
    }
}

static inline void rs_rcat_stop_congestion_test(rs_t *rs)
{
    switch ( rs->statem.rcat_state ) {
        case RS_STATE_WAIT:
            rs_timer_stop(t16);
            break;
    }
}
#endif


#endif  __MTP_RCAT_H__

