/*****************************************************************************

 @(#) $Id: mtp_rtac.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_RTAC_H__
#define __MTP_RTAC_H__

/*
 *  Referenced functions.
 */

static inline void rs_hmrt_transfer_allowed(rs_t *rs);

static inline void rs_rsrt_signalling_route_available(rs_t *rs);

static inline void rs_rtpc_controlled_rerouting(rs_t *rs);

static inline void rs_tcrc_signalling_route_available(rs_t *rs);

static inline void rs_tfrc_signalling_route_available(rs_t *rs);

static inline void rs_tsrc_signalling_route_available(rs_t *rs);

/*
 *  Forward declarations.
 */

static inline void rs_rtac_destination_accessible(rs_t *rs);
static inline void rs_rtac_forced_rerouting(rs_t *rs);
static inline void rs_rtac_forced_rerouting_not_required(rs_t *rs);
static inline void rs_rtac_forced_rerouting_terminated(rs_t *rs);
static inline void rs_rtac_restart_begins(rs_t *rs);
static inline void rs_rtac_restart_ends(rs_t *rs);
static inline void rs_rtac_send_transfer_allowed_message(rs_t *rs);
static inline void rs_rtac_stp_no_longer_used_for_destination(rs_t *rs);
static inline void rs_rtac_transfer_allowed_message(rs_t *rs);

/*
 *  Signalling Route Management (SRM)
 *  Transfer Allowed Control (RTAC)
 *  Figure 40/Q.704
 */

static inline void rs_rtac_transfer_allowed_message(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs_tsrc_signalling_route_available(rs);
            if ( !rs->statem.sp_restarting ) {
                rs_rsrt_signalling_route_available(rs);
                if ( rs->statem.forced_rerouting_in_progress ) {
                    rs_tfrc_signalling_route_available(rs);
                } else {
                    rs_tcrc_signalling_route_available(rs);
                    rs_rtpc_controlled_rerouting(rs);
                }
            }
//          break;
//  }
}

static inline void rs_rtac_destination_accessible(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs_hmrt_transfer_allowed(rs); /* FIXME: to all adjacent SPs */
//          break;
//  }
}

static inline void rs_rtac_stp_no_longer_used_for_destination(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs_hmrt_transfer_allowed(rs); /* FIXME: to concerned STP */
//          break;
//  }
}

static inline void rs_rtac_send_transfer_allowed_message(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs_hmrt_transfer_allowed(rs); /* FIXME: to concerned STP */
//          break;
//  }
}

static inline void rs_rtac_forced_rerouting(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs->statem.forced_rerouting_in_progress = 1;
//          break;
//  }
}

static inline void rs_rtac_forced_rerouting_terminated(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs->statem.forced_rerouting_in_progress = 0;
//          break;
//  }
}

static inline void rs_rtac_forced_rerouting_not_required(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs->statem.forced_rerouting_in_progress = 0;
//          break;
//  }
}

static inline void rs_rtac_restart_begins(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs->statem.forced_rerouting_in_progress = 0;
            rs->stagem.sp_restarting = 1;
//          break;
//  }
}

static inline void rs_rtac_restart_ends(rs_t *rs)
{
//  switch ( rs->statem.rtac_state ) {
//      case RS_STATE_IDLE:
            rs->stagem.sp_restarting = 0;
//          break;
//  }
}


#endif  __MTP_RTAC_H__

