/*****************************************************************************

 @(#) $Id: mtp_rtcc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_RTCC_H__
#define __MTP_RTCC_H__

/*
 *  Referenced functions.
 */

static inline void rs_hmrt_transfer_controlled(rs_t *rs);

static inline void rs_trcc_destination_congestion_status(rs_t *rs);

static inline void rs_tsfc_destination_congested(rs_t *rs);
static inline void rs_tsfc_destination_congestion_status(rs_t *rs);
static inline void rs_tsfc_distant_user_part_unavailable(rs_t *rs);

/*
 *  Forward declarations.
 */

static inline void rs_rtcc_send_transfer_controlled_message(rs_t *rs);
static inline void rs_rtcc_transfer_controlled(rs_t *rs);
static inline void rs_rtcc_user_part_unavailable_message(rs_t *rs);

/*
 *  Signalling Route Management (SRM)
 *  Transfer Controlled Control (RTCC)
 *  Figure 46a/Q.704
 */

/*
 *  This is a completely useless state machine.  It only has one state, and
 *  one if condition.  It could have been done with a macro.
 */

static inline void rs_rtcc_transfer_controlled(rs_t *rs)
{
//  switch ( rs->statem.rtcc_state ) {
//      case RS_STATE_IDLE:
#if national_option
            rs_trcc_destination_congestion_status(rs);
#else
            rs_tsfc_destination_congested(rs);
#endif
//          break;
//  }
}

static inline void rs_rtcc_send_transfer_controlled_message(rs_t *rs)
{
//  switch ( rs->statem.rtcc_state ) {
//      case RS_STATE_IDLE:
#if national_option
            if ( rs->statem.message_originated_at_sp )
                rs_tsfc_destination_congestion_status(rs);
            else
#endif
                rs_hmrt_transfer_controlled(rs); /* to concerned sp */
//          break;
//  }
}

static inline void rs_rtcc_user_part_unavailable_message(rs_t *rs)
{
//  switch ( rs->statem.rtcc_state ) {
//      case RS_STATE_IDLE:
            rs_tsfc_distant_user_part_unavailable(rs);
//          break;
//  }
}

#endif  __MTP_RTCC_H__

