/*****************************************************************************

 @(#) $Id: mtp_rtpc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_RTPC_H__
#define __MTP_RTPC_H__

/*
 *  Reference functions.
 */

static inline void rs_hmrt_transfer_prohibited(rs_t *rs);

static inline void rs_rsrt_start_route_set_test(rs_t *rs);

static inline void rs_tsrc_signalling_route_unavailable(rs_t *rs);

/*
 *  Forward declarations.
 */

static inline void rs_t8_timeout(rs_t *rs);

static inline void rs_rtpc_controlled_rerouting_terminated(rs_t *rs);
static inline void rs_rtpc_destination_inacessible(rs_t *rs);
static inline void rs_rtpc_message_received_for_inacessible_sp(rs_t *rs);
static inline void rs_rtpc_restart_begins(rs_t *rs);
static inline void rs_rtpc_restart_ends(rs_t *rs);
static inline void rs_rtpc_send_transfer_prohibited_message(rs_t *rs);
static inline void rs_rtpc_transfer_prohibited(rs_t *rs);

/*
 *  Signalling Route Management (SRM)
 *  Transfer Prohibited Control (RTPC)
 *  Figure 44/Q.704
 */

static inline void rs_t8_timeout(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_WAIT:
            rs->statem.rtpc_state = RS_STATE_IDLE;
            break;
    }
}

static inline void rs_rtpc_message_received_for_inacessible_sp(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs_hmrt_transfer_prohibited(rs);  /* FIXME: to concerned SP or STP */
            rs_timer_start(t8);
            rs->statem.rtpc_state = RS_STATE_WAIT;
            break;
    }
}

static inline void rs_rtpc_send_transfer_prohibited_message(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs_hmrt_transfer_prohibited(rs);  /* FIXME: to concerned SP or STP */
            rs_timer_start(t8);
            rs->statem.rtpc_state = RS_STATE_WAIT;
            break;
    }
}

static inline void rs_rtpc_destination_inacessible(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs_hmrt_transfer_prohibited(rs);  /* FIXME: to all adjacent SPs */
            rs_timer_start(t8);
            rs->statem.rtpc_state = RS_STATE_WAIT;
            break;
    }
}

static inline void rs_rtpc_transfer_prohibited(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            if ( rs->statem.controlled_rerouting_in_progress ) {
                rs->statem.transfer_prohibited = 1;
            } else {
                rs_tsrc_signalling_route_unavailable(rs);
                if ( !rs->statem.sp_restarting )
                    rs_rsrt_start_route_set_test(rs);
            }
            break;
    }
}

static inline void rs_rtpc_controlled_rerouting_terminated(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs->statem.controlled_rerouting_in_progress = 0;
            if ( rs->statem.transfer_prohibited ) {
                rs->statem.transfer_prohibited = 0;
                rs_tsrc_signalling_route_unavailable(rs);
                if ( !rs->statem.sp_restarting )
                    rs_rsrt_start_route_set_test(rs);
            }
            break;
    }
}

static inline void rs_rtpc_controlled_rerouting_terminated(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs->statem.controlled_rerouting_in_progress = 1;
            break;
    }
}

static inline void rs_rtpc_restart_begins(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs->statem.controlled_rerouting_in_progress = 0;
            rs->statem.transfer_prohibited = 0;
            rs->statem.sp_restarting = 1;
            break;
    }
}

static inline void rs_rtpc_restart_ends(rs_t *rs)
{
    switch ( rs->statem.rtpc_state ) {
        case RS_STATE_IDLE:
            rs->statem.sp_restarting = 0;
            break;
    }
}


#endif  __MTP_RTPC_H__

