/*****************************************************************************

 @(#) $Id: mtp_rtrc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_RTRC_H__
#define __MTP_RTRC_H__

/*
 *  Referenced functions.
 */

static inline void rs_hmrt_transfer_restricted_message(rs_t *rs);

static inline void rs_rsrt_start_route_set_test(rs_t *rs);

static inline void rs_tsrc_signalling_route_restricted(rs_t *rs);

/*
 *  Forward declarations.
 */

static inline void rs_rtrc_destination_restricted(rs_t *rs);
static inline void rs_rtrc_restart_begins(rs_t *rs);
static inline void rs_rtrc_restart_ends(rs_t *rs);
static inline void rs_rtrc_send_transfer_restricted_message(rs_t *rs);
static inline void rs_rtrc_transfer_restricted(rs_t *rs);

/*
 *  Signalling Route Management (SRM)
 *  Transfer Restricted Control (RTRC)
 *  Figure 46c/Q.704
 */

/*
 *  Another totally useless state machine with no states.
 */

#if national_option
static inline void rs_rtrc_transfer_restricted(rs_t *rs)
{
//  switch ( rs->statem.rtrc_state ) {
//      case RS_STATE_IDLE:
            rs_tsrc_signalling_route_restricted(rs);
            if ( !rs->statem.own_sp_restarting )
                rs_rsrt_start_route_set_test(rs);
//          break;
//  }
}

static inline void rs_rtrc_send_transfer_restricted_message(rs_t *rs)
{
//  switch ( rs->statem.rtrc_state ) {
//      case RS_STATE_IDLE:
            rs_hmrt_transfer_restricted_message(rs); /* to concerned SP */ /* to remote L3 */
//          break;
//  }
}

static inline void rs_rtrc_destination_restricted(rs_t *rs)
{
//  switch ( rs->statem.rtrc_state ) {
//      case RS_STATE_IDLE:
            rs_hmrt_transfer_restricted_message(rs); /* to all adjacent SPs,
                                                        except those to which
                                                        transfer prohibited
                                                        messages are sent. */
//          break;
//  }
}

static inline void rs_rtrc_restart_begins(rs_t *rs)
{
//  switch ( rs->statem.rtrc_state ) {
//      case RS_STATE_IDLE:
            rs->statem.sp_restarting = 1;
//          break;
//  }
}

static inline void rs_rtrc_restart_ends(rs_t *rs)
{
//  switch ( rs->statem.rtrc_state ) {
//      case RS_STATE_IDLE:
            rs->statem.sp_restarting = 0;
//          break;
//  }
}
#endif

#endif  __MTP_RTRC_H__

