/*****************************************************************************

 @(#) $Id: mtp_sm.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __LINUX_MTP_SM_H__
#define __LINUX_MTP_SM_H__

#ifndef ss7_ptr
#define ss7_ptr dn_ptr
#endif

/*
 *  Timer Value for MTP:
 */

#define MTP_T1_VALUE   /* {   500,*/   80/*,  1200 } *//* Delay on changeover */
#define MTP_T2_VALUE   /* {   700,*/  140/*,  2000 } *//* Waiting for changeover ack */
#define MTP_T3_VALUE   /* {   500,*/   80/*,  1200 } *//* Time controlled diversion delay */
#define MTP_T4_VALUE   /* {   500,*/   80/*,  1200 } *//* Waiting for 1st changeback ack */
#define MTP_T5_VALUE   /* {   500,*/   80/*,  1200 } *//* Waiting for changeback ack */
#define MTP_T6_VALUE   /* {   500,*/   80/*,  1200 } *//* Controlled rerouting delay */
#define MTP_T7_VALUE   /* {  1000,*/  150/*,  2000 } *//* Waiting for sdling connect ack */
#define MTP_T8_VALUE   /* {   800,*/  100/*,  1200 } *//* Transfer prohibited timer */
#define MTP_T9_VALUE   /* {     0,*/    0/*,     0 } *//* Not Used. */
#define MTP_T10_VALUE  /* { 30000,*/ 4500/*, 60000 } *//* Waiting for repeat SRST msg */
#define MTP_T11_VALUE  /* { 30000,*/ 6000/*, 90000 } *//* Transfer restricted timer */
#define MTP_T12_VALUE  /* {   800,*/  120/*,  1500 } *//* Waiting for inhibit ack */
#define MTP_T13_VALUE  /* {   800,*/  120/*,  1500 } *//* Waiting for force inhibit */
#define MTP_T14_VALUE  /* {  2000,*/  250/*,  3000 } *//* Waiting for inhibition ack */
#define MTP_T15_VALUE  /* {  2000,*/  250/*,  3000 } *//* Waiting to start SRSC test */
#define MTP_T16_VALUE  /* {  1400,*/  170/*,  2000 } *//* Waiting for SRSCT status */
#define MTP_T17_VALUE  /* {   800,*/  120/*,  1500 } *//* Delay for initial alignment */
#define MTP_T18_VALUE  /* {     0,*/    0/*,     0 } *//* MTP restart time */

/*
 *  Note: per ETSI ETS 300 001 (09/2000) timer values T7, T11, T15, T16 and
 *  T24 do not apply to ETSI.
 */

enum {
    /*
     *  These are abstract service primitives sent downwards from the SS7 NET
     *  protocol layer to the SS7 LINK interface.
     */
    SS7_L2_PDU = 0,
    SS7_L2_EMERGENCY,
    SS7_L2_EMERGENCY_CEASES,
    SS7_L2_START,
    SS7_L2_STOP,
    SS7_L2_RETRIEVE_BSNT,
    SS7_L2_RETRIEVAL_REQUEST_AND_FSNC,
    SS7_L2_RESUME,
    SS7_L2_CLEAR_BUFFERS,
    SS7_L2_LOCAL_PROCESSOR_OUTAGE,
    SS7_L2_CONGESTION_DISCARD,
    SS7_L2_CONGESTION_ACCEPT,
    SS7_L2_NO_CONGESTION,
    SS7_L2_LAST
};

enum {
    /*
     *  These are abstracts service primitives sent upwards from the SS7 LINK
     *  interface to the SS7 NET protocol level.
     */
    SS7_L3_PDU = 0,
    SS7_L3_LINK_CONGESTED,
    SS7_L3_LINK_CONGESTION_CEASED,
    SS7_L3_RETRIEVED_MESSAGES,
    SS7_L3_RETRIEVAL_COMPLETE,
    SS7_L3_RB_CLEARED,
    SS7_L3_BSNT,
    SS7_L3_IN_SERVICE,
    SS7_L3_OUT_OF_SERVICE,
    SS7_L3_REMOTE_PROCESSOR_OUTAGE,
    SS7_L3_REMOTE_PROCESSOR_RECOVERED,
    SS7_L3_RTB_CLEARED,
    SS7_L3_LAST
};

enum {
    /* 
     *  These are abstract service primitives sent upwards from the SS7 MTP
     *  interface to the MTP User protocol level.
     */
    SS7_L4_PDU = 0
};

enum {
    /*
     *  These are abstract service primitives sent upwards from the SS7 MTP
     *  interface to the SCCP protoocl level.
     */
    SS7_SCCP_PDU = 0
};

struct ss7_routeset;

#define SS7_MTPOPT_TRANSFER_FUNC    0x01    /* has MTP transfer function */
#define SS7_MTPOPT_MTP_RESTART      0x02    /* we are in MTP restart */
#define SS7_MTPOPT_CLUSTER_ROUTE    0x04    /* has cluster routing */
#define SS7_MTPOPT_XFER_RESTRICT    0x08    /* has transfer restriction option */
#define SS7_MTPOPT_MESSAGE_PRIO     0x10    /* has message priority option */
#define SS7_mTPOPT_MULTI_CONG_LEVEL 0x20    /* has multiple congestion levels */

struct ss7mtp_cb {
    struct ss7mtp_cb *next;         /* list of local address and bound user parts */
    struct ss7_addr saddr;          /* local address */
    unsigned ni;                    /* network indicator */
    struct ss7sccp_cp *sccp;        /* bound sccp protocol if any */
    struct sock *sks[16];           /* bound user part sockets */
    struct ss7_routeset *local;     /* local routeset for this address */
    struct ss7_routeset *sets;      /* routeset for this signaling point */
    int restart;                    /* are we mtp restarting? */
    int transfer;                   /* can we mtp transfer? */
    unsigned int t1t_value;         /* T1 (TEST) timer value */
    unsigned int t2t_value;         /* T2 (TEST) timer value */
    unsigned int t1_value;          /* T1 timer value */
    unsigned int t2_value;          /* T2 timer value */
    unsigned int t3_value;          /* T3 timer value */
    unsigned int t4_value;          /* T4 timer value */
    unsigned int t5_value;          /* T5 timer value */
    unsigned int t6_value;          /* T6 timer value */
    unsigned int t8_value;          /* T8 timer value */
    unsigned int t10_value;         /* T10 timer value */
    unsigned int t15_value;         /* T15 timer value */
    unsigned int t16_value;         /* T16 timer value */
    unsigned int t17_value;         /* T17 timer value */
    unsigned int t18_value;         /* T18 timer value */
    unsigned int t19_value;         /* T19 timer value */
    unsigned int t20_value;         /* T20 timer value */
    unsigned int t21_value;         /* T21 timer value */
    void (*input)(struct ss7mtp_cb *,struct sk_buff *skb);  /* intput method */
    int (*output)(struct sk_buff *skb, struct ss7mtp_cb *mtp, struct ss7_routeset *rt);
    int (*route)(struct sockaddr_ss7 *addr,struct ss7_routeset **retrt);
};


/* net/ss7/mtp_sm.c */
extern struct ss7mtp_cb *ss7mtp_all;
extern void mtp_input(struct ss7mtp_cb *mtp,struct sk_buff *skb);
extern void ss7mtp_input(struct sk_buff *skb);

#endif  __LINUX_MTP_SM_H__

