/*****************************************************************************

 @(#) $Id: mtp_tcrc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_TCRC_H__
#define __MTP_TCRC_H__

/*
 *  Referenced functions.
 */

static inline void rt_hmrt_update_routing_tables(rt_t *rt);

static inline void rt_rtpc_cancelled_rerouting_terimnated(rt_t *rt);

static inline void rt_tsrc_alternative_routing_data_request(rt_t *rt);
static inline void rt_tsrc_procedure_terminated(rt_t *rt);

/*
 *  Forward declarations.
 */

static inline void rt_t6_timeout(rt_t *rt)

static inline void rt_tcrc_alternative_routing_data(rt_t *rt)
static inline void rt_tcrc_signalling_route_available(rt_t *rt)
static inline void rt_tcrc_signalling_route_restricted(rt_t *rt)

/*
 *  Signalling Traffic Managmenet (STM)
 *  Controlled Rerouting Control (TCRC)
 *  Figure 33/Q.704
 */

static inline void rt_t6_timeout(rt_t *rt)
{
    switch ( rt->statem.tcrc_state ) {
        case RT_STATE_WAIT:
            /* Start traffic on new route, buffered messages first */
            rt_hmrt_update_routing_tables(rt);
            rt_tsrc_procedure_terminated(rt);
            rt_rtpc_cancelled_rerouting_terimnated(rt);
            rt->statem.tcrc_state = RT_STATE_IDLE;
            break;
    }
}

static inline void rt_tcrc_signalling_route_restricted(rt_t *rt)
{
    switch ( rt->statem.tcrc_state ) {
        case RT_STATE_IDLE:
            rt_tsrc_alternative_routing_data_request(rt);
            rt->statem.tcrc_state = RT_STATE_WAIT_FOR_ROUTING_DATA;
            break;
    }
}

static inline void rt_tcrc_signalling_route_available(rt_t *rt)
{
    switch ( rt->statem.tcrc_state ) {
        case RT_STATE_IDLE:
            rt_tsrc_alternative_routing_data_request(rt);
            rt->statem.tcrc_state = RT_STATE_WAIT_FOR_ROUTING_DATA;
            break;
    }
}

static inline void rt_tcrc_alternative_routing_data(rt_t *rt)
{
    /* Identified routing change */
    switch ( rt->statem.tcrc_state ) {
        case RT_STATE_IDLE:
            if ( rt->statem.routing_changed ) {
                /* Buffer concerned traffic in controlled rerouting buffer */
                rt_timer_start(t6);
                rt->statem.tcrc_state = RT_STATE_WAIT;
                break;
            } else {
                rt_tsrc_procedure_terminated(rt);
                rt_rtpc_cancelled_rerouting_terimnated(rt);
                rt->statem.tcrc_state = RT_STATE_IDLE;
            }
            break;
    }
}

#endif  __MTP_TCRC_H__

