/*****************************************************************************

 @(#) $Id: mtp_tfrc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_TFRC_H__
#define __MTP_TFRC_H__

/*
 *  Referenced functions.
 */

static inline void rt_hmrt_update_routing_tables(rt_t *rt);

static inline void rt_rtac_forced_rerouting_not_required(rt_t *rt);
static inline void rt_rtac_forced_rerouting_terminated(rt_t *rt);

static inline void rt_tsrc_alternative_routing_data_request(rt_t *rt);
static inline void rt_tsrc_procedure_terminated(rt_t *rt);

/*
 *  Forward declarations.
 */

static inline void rt_alternative_routing_data(rt_t *rt)
static inline void rt_signalling_route_available(rt_t *rt)
static inline void rt_signalling_route_unavailable(rt_t *rt)


static inline void rt_signalling_route_unavailable(rt_t *rt)
{
    switch ( rt->statem.tfrc_state ) {
        case RT_STATE_IDLE:
            /* Buffer concerned traffic in forced rerouting buffer */
            rt_tsrc_alternative_routing_data_request(rt);
            rt->statem.tfrc_state = RT_STATE_WAIT_FOR_ROUTING_DATA;
            break;
    }
}

static inline void rt_alternative_routing_data(rt_t *rt)
{
    /* Identifies routing change and availability of alternative route */
    switch ( rt->statem.tfrc_state ) {
        case RT_STATE_WAIT_FOR_ROUTING_DATA:
            if ( rt->statem.routing_changed ) {
                if ( rt->statem.alternative_route_available ) {
                    /* Start traffic on new route, buffered messages first */
                } else {
                    /* Discard messages in forced rerouting buffer */
                }
                rt_hmrt_update_routing_tables(rt);
            }
            rt_tsrc_procedure_terminated(rt);
            rt_rtac_forced_rerouting_terminated(rt);
            rt->statem.tfrc_state = RT_STATE_IDLE;
            break;
    }
}

static inline void rt_signalling_route_available(rt_t *rt)
{
    switch ( rt->statem.tfrc_state ) {
        case RT_STATE_WAIT_FOR_ROUTING_DATA:
            /* Start traffic on newly available route, buffered message first */
            rt_rtac_forced_rerouting_not_required(rt);
            rt->statem.tfrc_state = RT_STATE_IDLE;
            break;
    }
}



#endif  __MTP_TFRC_H__

