/*****************************************************************************

 @(#) $Id: mtp_tsfc.h,v 0.7.4.1 2001/02/18 09:44:19 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:19 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTP_TSFC_H__
#define __MTP_TSFC_H__

/*
 *  Referenced functions.
 */

static inline void mtp_pause(rs_t *rs);
static inline void mtp_restart_ends_indication(rs_t *rs);
static inline void mtp_resume(rs_t *rs);
static inline void mtp_status(rs_t *rs);

static inline void rs_rtcc_send_transfer_controlled(rs_t *rs);

/*
 *  Forward declarations.
 */

static inline void rs_tsfc_destination_accessible(rs_t *rs);
static inline void rs_tsfc_destination_congested(rs_t *rs);
static inline void rs_tsfc_destination_congestion_status(rs_t *rs);
static inline void rs_tsfc_destination_inaccessible(rs_t *rs);
static inline void rs_tsfc_distant_user_part_unavailable(rs_t *rs);
static inline void rs_tsfc_message_for_congested_destination(rs_t *rs);
static inline void rs_tsfc_restart_begins(rs_t *rs);
static inline void rs_tsfc_restart_ends(rs_t *rs);

/*
 *  Signalling Traffic Management (STM)
 *  Signalling Traffic Flow Control (TSFC)
 *  Figure 34a/Q.704
 */

static inline void rs_tsfc_destination_congested(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            mtp_status(rs);
            break;
    }
}

static inline void rs_tsfc_message_for_congested_destination(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            if ( !(rs->statem.message % rs->config.n) ) {
                rs->statem.message++;
                /* Is this the 1st message for concerned DPC? */
                /* Is this the n, 2n, 3n, message for DPC? */
                if ( /* Does OPC = own OPC? */ ) {
                    mtp_status(rs);
                } else {
                    rs_rtcc_send_transfer_controlled(rs);
                }
            } else
                rs->statem.message++;
            break;
    }
}

static inline void rs_tsfc_destination_inaccessible(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            mtp_pause(rs);
            break;
    }
}

static inline void rs_tsfc_destination_accessible(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            mtp_resume(rs);
            break;
    }
}

static inline void rs_tsfc_destination_congestion_status(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            mtp_status(rs);
            break;
    }
}

static inline void rs_tsfc_restart_begins(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            rs->statem.tsfc_state = RS_STATE_RESTART;
            break;
    }
}

static inline void rs_tsfc_restart_ends(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_RESTART:
            mtp_restart_ends_indication(rs);
            rs->statem.tsfc_state = RS_STATE_IDLE;
            break;
    }
}

static inline void rs_tsfc_distant_user_part_unavailable(rs_t *rs)
{
    switch ( rs->statem.tsfc_state ) {
        case RS_STATE_IDLE:
            mtp_status(rs);
            break;
    }
}

#endif  __MTP_TSFC_H__

