/*****************************************************************************

 @(#) $Id: sccp.h,v 0.7.4.1 2001/02/18 09:44:21 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:21 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SCCPI_SCCP_H__
#define __SCCPI_SCCP_H__

#ifdef __KERNEL__

typedef struct sccp_dcalls {
    void (*mtp_transfer     )(struct sccp*, mblk_t *, int, int, int);
    void (*mtp_pause        )(struct sccp*, int);
    void (*mtp_resume       )(struct sccp*, int);
    void (*mtp_status       )(struct sccp*, int, int);
    void (*mtp_restart_ends )(struct sccp*);
} sccp_dcalls_t;

typedef struct sccp_devops {
    void (*mtp_transfer     )(void *, mblk_t *, int, int, int);
} sccp_devops_t;

typedef struct sccp_driver {
    struct sccp_driver  *next;
    int                 cmajor;
    int                 nminor;
    struct sccp         *list;
    struct streamtab    *info;
    lmi_lmiops_t        *lmiops;
    sccp_devops_t       *devops;
    sccp_dcalls_t       *dcalls;
    void                *lowops;
    void                *lcalls;
} sccp_driver_t;

typedef lmi_option_t sccp_option_t;

typedef struct sccp_timers {
} sccp_timers_t;

SCCP_MAX_BUFCALLS 8

typedef sccp_ulong sccp_bufcid_t[SCCP_MAX_BUFCALLS];

typedef struct sccp {
    struct sccp     *next;      /* next stream in list                  */
    sccp_short      cminor;     /* minor number of this device          */
    queue_t         *rq;        /* upper read queue                     */
    queue_t         *wq;        /* upper write queue                    */
    sccp_ulong      state;      /* SCCP interface state                 */
    sccp_ulong      flags;      /* SCCP interface flags                 */
    sccp_driver     *driver;    /* SCCP driver structure                */
    struct sccp     *other;     /* SCCP other (perhaps mate)            */
    void            *priv;      /* SCCP driver private                  */
    sccp_option_t   option;     /* SCCP protocol variant and options    */
    sccp_config_t   config;     /* SCCP protocol configuration          */
    sccp_statem_t   statem;     /* SCCP protocol state variables        */
    sccp_stats_t    stats;      /* SCCP protocol statistics             */
    sccp_notify_t   notify;     /* SCCP protocol events                 */
    sccp_timers_t   timers;     /* SCCP protocol timers                 */
    sccp_bufcid_t   bufids;     /* SCCP protocol buffer calls           */
    tcap_dcalls_t   *ucalls;    /* SCCP calls to SCCP-USER              */
} mtpl_t;
}


#endif  /* __KERNEL__ */

#endif  __SCCPI_SCCP_H__
