/*****************************************************************************

 @(#) $Id: sdl.h,v 0.7.4.1 2001/02/18 09:44:26 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:26 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SDL_H__
#define __SDL_H__

#ifdef __KERNEL__

struct sdl;
struct sdt;

typedef struct sdl_ucalls {
    void (*daedr_received_bits )(struct sdl *, mblk_t *);
    void (*daedr_correct_su    )(struct sdl *, int);
    void (*daedr_su_in_error   )(struct sdl *);
    void (*daedt_tx_request    )(struct sdl *);
} sdl_ucalls_t;

typedef struct sdl_dcalls {
    void (*daedt_xmit         )(struct sdl *, mblk_t *);
    void (*daedt_start        )(struct sdl *);
    void (*daedr_start        )(struct sdl *);
} sdl_dcalls_t;

typedef struct sdl_mcalls {
    void (*xmit    )(struct sdl *, mblk_t *);
    void (*rx_start)(struct sdl *);
    void (*tx_start)(struct sdl *);
} sdl_mcalls_t;

typedef struct sdl_driver {
    struct sdl_driver   *next;      /* next driver structure        */
    int                 cmajor;     /* major device number          */
    int                 nminor;     /* number of minor devices      */
    struct sdl          *list;      /* list of device structures    */
    struct streamtab    *info;      /* streamtab for this driver    */
    struct lmi_ops      ops;        /* device operations            */
    struct dev_dcalls   *dcalls;    /* module calling driver        */
    struct dev_ucalls   *ucalls;    /* driver calling module        */
} sdl_driver_t;

typedef lmi_option_t sdl_option_t;

typedef struct sdl_timers {
} sdl_timers_t;

#define SDL_MAX_TIMERIDS 0
#define SDL_MAX_BUFCALLS 8

typedef sdl_ulong sdl_bufcid_t[SDL_MAX_BUFCALLS];

typedef struct sdl {
    struct sdl          *next;      /* next device in device list       */
    struct sdt          *module;    /* upper for dev/mux, other for mod */
    struct sdl_ucalls   *ucalls;    /* upper module calls               */
    struct sdl_mcalls   *dcalls;    /* lower driver calls               */
    struct dev          *device;    /* driver device (lower for mux)    */
    sdl_driver_t        *driver;    /* driver struct for driver         */
    dev_t               devnum;     /* driver device (null for module)  */
    queue_t             *rq;        /* read queue                       */
    queue_t             *wq;        /* write queue                      */
    sdl_ulong           state;      /* LM interface state               */
    sdl_ulong           flags;      /* LM interface flags               */
    sdl_ulong           ids[0];     /* Protocol structure follows       */
    sdl_timers_t        timers;
    sdl_bufcid_t        bufids;
    sdl_option_t        option;
    sdl_config_t        config;
    sdl_statem_t        statem;
    sdl_stats_t         stats;
    sdl_notify_t        notify;
} sdl_t;

extern int sdl_register_driver(major_t, int, char *, lmi_ops_t *, dev_dcalls_t *);
extern int sdl_unregister_driver(major_t);

#endif /* __KERNEL__ */

#endif  __SDL_H__
