/*****************************************************************************

 @(#) $Id: sdt.h,v 0.7.4.1 2001/02/18 09:44:30 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:30 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SDT_H__
#define __SDT_H__

#ifdef __KERNEL__

struct sdt;
struct sl;

typedef struct sdt_ucalls {
    void (*rc_signal_unit           )(struct sdt *, mblk_t *);
    void (*rc_congestion_accept     )(struct sdt *);
    void (*rc_congestion_discard    )(struct sdt *);
    void (*rc_no_congestion         )(struct sdt *);
    void (*iac_correct_su           )(struct sdt *);
    void (*iac_abort_proving        )(struct sdt *);
    void (*lsc_link_failure         )(struct sdt *);
    void (*txc_transmission_request )(struct sdt *);
} sdt_ucalls_t;

typedef struct sdt_dcalls {
    void (*daedt_xmit          )(struct sdt *, mblk_t *);
    void (*daedt_start         )(struct sdt *);
    void (*daedr_start         )(struct sdt *);
    void (*aerm_start          )(struct sdt *);
    void (*aerm_stop           )(struct sdt *);
    void (*aerm_set_tin        )(struct sdt *);
    void (*aerm_set_tie        )(struct sdt *);
    void (*suerm_start         )(struct sdt *);
    void (*suerm_stop          )(struct sdt *);
} sdt_dcalls_t;

typedef struct sdt_mcalls {
    void (*daedt_xmit         )(struct sdt *, mblk_t *);
    void (*daedt_start        )(struct sdt *);
    void (*daedr_start        )(struct sdt *);
} sdt_mcalls_t;

typedef struct sdt_driver {
    struct sdt_driver   *next;
    int                 cmajor;
    int                 nminor;
    struct sdt          *list;
    struct streamtab    *info;
    struct lmi_ops      ops;
    struct sdl_dcalls   *dcalls;
    struct sdl_ucalls   *ucalls;
} sdt_driver_t;

typedef lmi_option_t sdt_option_t;

typedef struct sdt_timers {
    sdt_ulong       t8; /* t8 timer id */
} sdt_timers_t;

#define SDT_MAX_TIMERIDS 1
#define SDT_MAX_BUFCALLS 8

typedef sdt_ulong sdt_bufcid_t[SDT_MAX_BUFCALLS];

typedef struct sdt {
    struct sdt          *next;
    struct sl           *module;
    struct sdt_ucalls   *ucalls;
    struct sdt_mcalls   *dcalls;
    struct sdl          *device;
    sdt_driver_t        *driver;
    dev_t               devnum;
    queue_t             *rq;
    queue_t             *wq;
    sdt_ulong           state;
    sdt_ulong           flags;
    sdt_ulong           ids[0];
    sdt_timers_t        timers;
    sdt_bufcid_t        bufids;
    lmi_option_t        option;
    sdt_config_t        config;
    sdt_statem_t        statem;
    sdt_stats_t         stats;
    sdt_notify_t        notify;
} sdt_t;

extern int sdt_register_driver(major_t, int, char *, lmi_ops_t *, sdl_dcalls_t *);
extern int sdt_unregister_driver(major_t);


#endif /* __KERNEL__ */

#endif  __SDT_H__
