/*****************************************************************************

 @(#) $Id: sdt_sdl.c,v 0.7.4.1 2001/02/18 09:44:31 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:31 $ by $Author: brian $

 *****************************************************************************/

static char const ident[] = "$Id: sdt_sdl.c,v 0.7.4.1 2001/02/18 09:44:31 brian Exp $";

/*
 *  This is an implementation of the SDT (Signalling Data Terminal) as a
 *  pushable module which pushes over a SDLI (Signalling Data Link Interface)
 *  compliant driver.
 */

#define SDT_DESCRIP   "SS7/SDT/SDLI: (Signalling Data Terminal/Link) STREAMS MODULE."
#define SDT_COPYRIGHT "Copyright (c) 1997-2001 Brian Bidulock.  All Rights Reserved."
#define SDT_DEVICES   "Supports SDLI compliant drivers."
#define SDT_CONTACT   "Brian Bidulock <bidulock@openss7.org>"
#define SDT_BANNER    SDT_DESCRIP   "\n" \
                      SDT_COPYRIGHT "\n" \
                      SDT_DEVICES   "\n" \
                      SDT_CONTACT   "\n"

#ifdef MODULE
MODULE_AUTHOR(SDT_CONTACT);
MODULE_DESCRIPTION(SDT_DESCRIP);
MODULE_SUPPORTED_DEVICES(SDT_DEVICES);
#define MODULE_STATIC static
#else
#define MOD_INC_USE_COUNT
#define MOD_DEC_USE_COUNT
#define MODULE_STATIC
#endif

#ifndef SDT_DEBUG
#define SDT_DEBUG 2
#endif
int sdt_debug = SDT_DEBUG;

#define SDT_MOD_ID      0x1111
#define SDT_MOD_NAME    "sdt_udp"
#define SDT_MIN_SDU     3
#define SDT_MAX_SDU     277
#define SDT_HIWATER     0
#define SDT_LOWATER     0
#define SDT_N_MINOR     256 /* as many as possible */
