/*****************************************************************************

 @(#) $Id: sdti_skeleton.h,v 0.7.4.1 2001/02/18 09:44:31 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:31 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SDTI_SKEL_H__
#define __SDTI_SKEL_H__

#ifndef sdt_ulong
typedef unsigned long  sdt_ulong;
typedef unsigned short sdt_ushort;
typedef unsigned char  sdt_uchar;
#endif

typedef struct {
    sdt_ulong   M;      /* IAC number of proving periods        */
    sdt_ulong   Tin;    /* AERM normal proving threshold        */
    sdt_ulong   Tie;    /* AERM emerg  proving threshold        */
    sdt_ulong   T;      /* SUERM error threshold                */
    sdt_ulong   D;      /* SUERM error rate parameter           */
    sdt_ulong   N;      /* Octets per SU error in OC mode       */
    sdt_ulong   Te;     /* EIM error threshold                  */
    sdt_ulong   De;     /* EIM correct decrement                */
    sdt_ulong   Ue;     /* EIM error increment                  */
} sdt_config_t;

typdef struct {
    sdt_ulong   daedt_state;            /* DAEDT state variable      */
    sdt_ulong   daedr_state;            /* DAEDR state variable      */
    sdt_ulong     octet_counting_mode;  /* receivers freewheeling    */
    sdt_ulong   aerm_state;             /* AERM  state variable      */
    sdt_ulong     Ca;                   /* AERM  error counter       */
    sdt_ulong     Ti;                   /* AERM  threshold           */
    sdt_ulong   suerm_state;            /* SUERM state variable      */
    sdt_ulong     Cs;                   /* SUERM error counter       */
    sdt_ulong     Ns;                   /* SUERM su counter          */
    sdt_ulong   eim_state;              /* EIM   state variable      */
    sdt_ulong     Ce;                   /* EIM   counter             */
    sdt_ulong     su_received;          /* EIM   su received flag    */
    sdt_ulong     interval_error;       /* EIM   interval error flag */
} sdt_statem_t;

typedef struct {
    sdt_ulong   iobase;
    sdt_ulong   irq;
    sdt_ulong   dma_rx;
    sdt_ulong   dma_tx;
    sdt_ulong   ifmode;
    sdt_ulong   ifclock;
} sdt_device_t;

#define SDT_STATE_IDLE          0
#define SDT_STATE_IN_SERVICE    1
#define SDT_STATE_MONITORING    1



#endif  __SDTI_SKEL_H__
