/*****************************************************************************

 @(#) $Id: m2pa.h,v 0.7.4.1 2001/02/18 09:44:33 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:33 $ by $Author: brian $

 *****************************************************************************/

#ifndef __M2PA_H__
#define __M2PA_H__

/*
 *  Notes:  M2PA uses extended sequence numbers.  Each IP link maps onto a
 *  single SCTP association.  Each M2PA endpoint could be client or server.
 *  Server must know (somehow) port numbers assigned by clients to links.
 *  There must be an association of SLC and client-IP-port number at each end
 *  of association.  For SLI we can do this on both client and server by
 *  assigning an IP-port number on the client using a PPA_ATTACH.
 *
 *  M2PA replaces IAC in SS7 with establishing the SCTP connection and
 *  determining whether SRTT is suitable.  M2PA peers must exchange
 *  M2PA_LINK_STATUS_IN_SERVICE messages before the link is considered
 *  aligned.  A timer T1 (5-150s) is running while waiting for an
 *  M2PA_LINK_STATUS_IN_SERVICE from the peer.
 *
 *  Local and remote processor outage handling is similare to SS7 L2.
 *
 *  Receive congestion can be handled as with SS7 L2.
 *
 *  Error monitoring must be done by SCTP.
 *
 *  Link status message take priority over data messages.  This is a problem.
 *  If a SIPO or SIOS is received ahead of a number of data messages what is
 *  done with the messages in flight?
 *
 *  Flush buffers is implementation dependent. Hmmm.  This may require a RB,
 *  TB and RTB outside the scope of SCTP.
 *
 *  Transmit congestion is implementation dependent.  Hmmm.  This may require
 *  a TB and RTB outside the scope of SCTP.
 *
 *  BSNT is the last message received by SCTP User Data stream before any
 *  gaps in the stream sequence number.  This may be possible using an
 *  independent sequence number outside of the SCTP sequence number (but
 *  which tracks it) if acknowledgements are given to SCTP user when messages
 *  are acknolwedged.  Check SCTP spec.
 *
 *  Acknowledged messages which are gapped will wind up being retransmitted
 *  on the alternate link.
 *
 *
 */

enum {
};

#endif  __M2PA_H__
