/*****************************************************************************

 @(#) $Id: m2pa_parse.h,v 0.7.4.1 2001/02/18 09:44:33 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:33 $ by $Author: brian $

 *****************************************************************************/

#ifndef __M2PA_PARSE_H__
#define __M2PA_PARSE_H__

struct m2pa_header {
    unsigned version:8  __attribute__ ((packed));
    unsigned spare  :8  __attribute__ ((packed));
    unsigned mtype  :16 __attribute__ ((packed));
    unsigned length :32 __attribute__ ((packed));
} __attribute__ ((packed));

#define M2PA_VERSION 0x01

#define M2PA_MTYPE_USER_DATA    0x0601
#define M2PA_MTYPE_LINK_STATUS  0x0602

struct m2pa_user_data {
    struct m2pa_header header __attribute__ ((packed));
} __attribute__ ((packed));

/* followed by user data */
/* user data is SS7 message including LI */

struct m2pa_link_status {
    struct m2pa_header header __attribute__ ((packed));
    unsigned status :32 __attribute__ ((packed));
} __attribute__ ((packed));

#define M2PA_STATUS_IN_SERVICE             1
#define M2PA_STATUS_PROCESSOR_OUTAGE       2
#define M2PA_STATUS_PROCESSOR_OUTAGE_ENDED 3



#endif  __M2PA_PARSE_H__
