/*****************************************************************************

 @(#) $Id: sl.h,v 0.7.4.1 2001/02/18 09:44:33 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:33 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SL_H__
#define __SL_H__

#ifdef  __KERNEL__

struct sl;
struct lk;

typedef struct sl_ucalls {
    void (*sl_pdu           )(struct sl *, mblk_t *);
    void (*sl_congested     )(struct sl *, int, int);
    void (*sl_no_cong       )(struct sl *, int, int);
    void (*sl_rtrv_msg      )(struct sl *, mblk_t *);
    void (*sl_rtrv_comp     )(struct sl *);
    void (*sl_rb_cleared    )(struct sl *);
    void (*sl_bsnt          )(struct sl *, int);
    void (*sl_in_service    )(struct sl *);
    void (*sl_out_of_service)(struct sl *, int);
    void (*sl_rpoutage      )(struct sl *);
    void (*sl_rprecovered   )(struct sl *);
    void (*sl_rtb_cleared   )(struct sl *);
} sl_ucalls_t;

typedef struct sl_dcalls {
    void (*sl_pdu               )(struct sl *, mblk_t *);
    void (*sl_emerg             )(struct sl *);
    void (*sl_normal            )(struct sl *);
    void (*sl_start             )(struct sl *);
    void (*sl_stop              )(struct sl *);
    void (*sl_bsnt              )(struct sl *);
    void (*sl_fsnc              )(struct sl *, int);
    void (*sl_resume            )(struct sl *);
    void (*sl_clear_bufs        )(struct sl *);
    void (*sl_lpo               )(struct sl *);
    void (*sl_cg_accept         )(struct sl *);
    void (*sl_cg_discard        )(struct sl *);
    void (*sl_no_cong           )(struct sl *);
    void (*sl_power_on          )(struct sl *);
} sl_dcalls_t;

typedef struct sl_mcalls {
    void (*daedt_xmit          )(struct sl *, mblk_t *);
    void (*daedt_start         )(struct sl *);
    void (*daedr_start         )(struct sl *);
    void (*aerm_start          )(struct sl *);
    void (*aerm_stop           )(struct sl *);
    void (*aerm_set_tin        )(struct sl *);
    void (*aerm_set_tie        )(struct sl *);
    void (*suerm_start         )(struct sl *);
    void (*suerm_stop          )(struct sl *);
} sl_mcalls_t;

typedef struct sl_driver {
    struct sl_driver    *next;
    int                 cmajor;
    int                 nminor;
    struct sl           *list;
    struct streamtab    *info;
    struct lmi_ops      ops;
    struct sdt_dcalls   *dcalls;
    struct sdt_ucalls   *ucalls;
} sl_driver_t;

typedef lmi_option_t sl_option_t;

typedef struct sl_timers {
    sl_ulong    t1;  /* t1 timer id */
    sl_ulong    t2;  /* t2 timer id */
    sl_ulong    t3;  /* t3 timer id */
    sl_ulong    t4;  /* t4 timer id */
    sl_ulong    t5;  /* t5 timer id */
    sl_ulong    t6;  /* t6 timer id */
    sl_ulong    t7;  /* t7 timer id */
} sl_timers_t;

#define SL_MAX_TIMERIDS 7
#define SL_MAX_BUFCALLS 8

typedef sl_ulong sl_bufcid_t[SL_MAX_BUFCALLS];

typedef struct sl {
    struct sl           *next;
    struct lk         *module;
    struct sl_ucalls    *ucalls;
    struct sl_mcalls    *dcalls;
    struct sdt          *device;
    sl_driver_t         *driver;
    dev_t               devnum;
    queue_t             *rq;
    queue_t             *wq;
    sl_ulong            state;
    sl_ulong            flags;
    sl_ulong            ids[0];
    sl_timers_t         timers;     /* SL protocol timers               */
    sl_bufcid_t         bufids;     /* SL protocol buffer calls         */
    sl_option_t         option;     /* SL protocol variant and options  */
    sl_config_t         config;     /* SL protocol configuration        */
    sl_statem_t         statem;     /* SL protocol state variables      */
    sl_stats_t          stats;      /* SL protocol statistics           */
    sl_notify_t         notify;     /* SL protocol events               */
    bufq_t              tb;         /* Transmission buffer              */
    bufq_t              rtb;        /* Retransmission buffer            */
                                    /* FIXME: must initialize rtb       */
} sl_t;

extern int sl_register_driver(major_t, int, char *, lmi_ops_t *, sdt_dcalls_t *);
extern int sl_unregister_driver(major_t);

#endif  /* __KERNEL__ */

#endif  __SL_H__
