/*****************************************************************************

 @(#) $Id: sli_stats.h,v 0.7 2000/11/15 10:54:52 brian Exp $

 -----------------------------------------------------------------------------

     Copyright (C) 2000  Brian Bidulock.  All Rights Reserved.


                                  PUBLIC LICENSE

     This license is provided without fee, provided that the above copy-
     right notice and this public license must be retained on all copies,
     extracts, compilations and derivative works.  Use or distribution of
     this work in a manner that restricts its use except as provided here
     will render this license void.

     The author(s) hereby waive any and all other restrictions in respect
     of their copyright in this software and its associated documentation.
     The authors(s) of this software place in the public domain any novel
     methods or processes which are embodied in this software.

     The author(s) undertook to write it for the sake of the advancement
     of the Arts and Sciences, but it is provided as is, and the author(s)
     will not take any responsibility in it.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2000/11/15 10:54:52 $ by $Author: brian $

 $Log: sli_stats.h,v $
 Revision 0.7  2000/11/15 10:54:52  brian
 Added m2pa and sli stats files.

 *****************************************************************************/

#ident @(#) $Id: sli_stats.h,v 0.7 2000/11/15 10:54:52 brian Exp $

#ifndef __SLI_STATS_H__
#define __SLI_STATS_H__

/*
 *  This header file provides definitions of the statistics structures which
 *  must be maintained by the Signalling Link service provider.  These
 *  statistics are derived from ITU-T Recommendation Q.752.  Additional
 *  statistics can be derived from TR-1078 and GR-82-CORE.
 */


/*
 * STATISTICS (Per Q.752)
 */

/*
    Table 1.

    1.1  Duration of link in the In-service state       (s/SL - 30 min.)
    1.2  SL failure - All reasons                       (Event/SL - occur)
    1.3  SL failure - Abnormal FIBR/BSNR                (Event/SL - occur)
    1.4  SL failure - Excessive delay of ack.           (Event/SL - occur)
    1.5  SL failure - Excessive error rate              (Event/SL - occur)
    1.6  SL failure - Excessive duration of congestion  (Event/SL - occur)
    1.7  SL alignment or proving failure                (Event/SL - 5,30 min)
    1.8  Number of signal units received in error       (Event/SL - 5,30 min)
    1.9  Number of negative ack. received               (Event/SL - 5,30 min)
    1.10 Local automatic changeover                     (Event/SL - occur,30 min)
    1.11 Local automatic changeback                     (Event/SL - occur)
    1.12 SL restoration                                 (Event/SL - occur)

    Table 2.

    2.1  Duration of SL unavailability                  (s/SL - 30 min)
             (for any reason)
    2.2  - deleted -
    2.3  - deleted -
    2.4  - deleted -
    2.5  Duration of SL inhibition                      (s/SL - 30 min)
             due to local management actions
    2.6  Duration of SL inhibition                      (s/SL - 30 min)
             due to remote managmenet actions
    2.7  Duration of SL unavailability                  (s/SL - 30 min)
             due to link failure
    2.8  - deleted -
    2.9  Duration of SL unavailability                  (s/SL - 30 min)
             due to remote processor outage
    2.10 Start of remote processor outage               (Event/SL - occur)
    2.11 Stop of remote processor outage                (Event/SL - occur)
    2.12 - deleted -
    2.13 Local management inhibit                       (Event/SL - 5,30 min)
    2.14 Local management uninhibit                     (Event/SL - 5,30 min)
    2.15 Duration of local busy                         (SIBs/SL -  5,30 min)
    2.16 Start of local inhibition                      (Event/SL - occur)
    2.17 End of local inhibition                        (Event/SL - occur)
    2.18 Start of remote inhibition                     (Event/SL - occur)
    2.19 End of remote inhibition                       (Event/SL - occur)

    Table 3.

    3.1  Number of SIF and SIO octets transmitted       (Octets/SL - 5,30 min)
    3.2  Octets retransmitted                           (Octets/SL - 5,30 min)
    3.3  Number of message signal units transmitted     (MSUs/SL - 5,30 min)
    3.4  Number of SIF and SIO octets received          (Octets/SL - 5,30 min)
    3.5  Number of message signal units received        (MSUs/SL - 5,30 min)
    3.6  SL congestion indications                      (Event/SL - 1stD,5,30 min)
    3.7  Cumulative duration of SL congestion           (s/SL - 30 min)
    3.8  - deleted -
    3.9  Stop of SL ongestion                           (Event/SL - 1stD)
    3.10 MSUs discarded due to SL congestion            (MSUs/SL 5,30 min)
    3.11 Number of congestion events                    (Event/SL - 1stD,5,30 min)
             resulting in loss of MSUs
 */

typedef struct sl_stats {
    sl_ulong    sus_in_error;           /* Q.752 Table 1.8 */
    sl_ulong    nacks_received;         /* Q.752 Table 1.9 */
} sl_stats_t;


#endif  __SLI_STATS_H__
