/*****************************************************************************

 @(#) $Id: sls.h,v 0.7.4.1 2001/02/18 09:44:36 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:36 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_H__
#define __SLS_H__

#ifdef __KERNEL__

/* multiplexor lower stream definitions (per link) */

struct lk;
struct ls;

typedef struct lk_ucalls {
    void (*sl_signal_unit)(struct lk *, int, mblk_t *);
    void (*sl_failure    )(struct lk *, int);
    void (*sl_restored   )(struct lk *);
    void (*sl_inhibited  )(struct lk *);
    void (*sl_congested  )(struct lk *);
} lk_ucalls_t;

typedef struct lk_dcalls {
    void (*sl_signal_unit)(struct lk *, int, mblk_t *);
    void (*sl_stop       )(struct lk *);
    void (*sl_start      )(struct lk *);
    void (*sl_restart    )(struct lk *);
    void (*sl_inhibit    )(struct lk *);
    void (*sl_uninhibit  )(struct lk *);
} lk_dcalls_t;

typedef struct lk_mcalls {
    void (*sl_pdu       )(struct lk *, mblk_t *);
    void (*sl_emerg     )(struct lk *);
    void (*sl_normal    )(struct lk *);
    void (*sl_start     )(struct lk *);
    void (*sl_stop      )(struct lk *);
    void (*sl_bsnt      )(struct lk *);
    void (*sl_fsnc      )(struct lk *, int);
    void (*sl_resume    )(struct lk *);
    void (*sl_clear_bufs)(struct lk *);
    void (*sl_lpo       )(struct lk *);
    void (*sl_cg_accept )(struct lk *);
    void (*sl_cg_discard)(struct lk *);
    void (*sl_no_cong   )(struct lk *);
    void (*sl_power_on  )(struct lk *);
} lk_mcalls_t;

typedef struct lk_driver {
    struct lk_driver *next;
    int              cmajor;
    int              minor;
    struct lk        *list;
    struct streamtab *info;
    struct lmi_ops   ops;
    struct sl_dcalls *dcalls;
    struct sl_ucalls *ucalls;
} lk_driver_t;

typedef lmi_option_t lk_option_t;

typedef struct lk_timers {
    lk_ulong    t;      /* co/cb         timer */
    lk_ulong    tt1;    /* t1 (SLTC ACK) timer */
    lk_ulong    tt2;    /* t2 (SLTC SND) timer */
    lk_ulong    t1;     /* TCOC timer */
    lk_ulong    t2;     /* TCOC timer */
    lk_ulong    t3;     /* TCBC timer */
    lk_ulong    t4;     /* TCBC timer */
    lk_ulong    t5;     /* TCBC timer */
    lk_ulong    t7;
    lk_ulong    t12;    /* Waiting for uninhibit acknowledge */
    lk_ulong    t13;    /* Waiting for force unihibit */
    lk_ulong    t14;    /* Waiting for inhibition acknowledgement */
    lk_ulong    t17;    /* Delay to avoid oscillation of initial alignment
                           failure and link restart */
    lk_ulong    t22;    /* Local inhibit test timer */
    lk_ulong    t23;    /* Remote inhibit test timer */
    lk_ulong    t24;    /* Stabilising timer after removal of local processor
                           outage,  used in LPO latching to RPO (national
                           option) */

} lk_timers_t;

#define LK_MAX_TIMERIDS 3
#define LK_MAX_BUFCALLS 8

typedef ls_ulong lk_bufcid_t[LK_MAX_BUFCALLS];

typedef struct lk {
    struct lk        *next;
    struct ls        *module;
    struct lk_ucalls *ucalls;
    struct lk_mcalls *dcalls;
    struct sl        *device;
    lk_driver_t      *driver;
    int              muxid;
    queue_t          *rq;
    queue_t          *wq;
    ls_ulong         state;
    ls_ulong         flags;
    ls_ulong         ids[0];
    lk_timers_t      timers;
    lk_bufcid_t      bufids;
    lk_option_t      option;
    lk_config_t      config;
    lk_statem_t      statem;
    lk_stats_t       stats;
    lk_notify_t      notify;
} lk_t;

/* multiplexor upper stream definitions (per link set) */

struct mtpl;

typedef struct ls_ucalls {
    void (*ls_alternative_routing_data_request)(struct ls *, int);
    void (*ls_cancel_link_inhibited)(struct ls *, int);
    void (*ls_changeover_executed)(struct ls *, int);
    void (*ls_changeover_not_required)(struct ls *, int);
    void (*ls_inhibit_denied)(struct ls *, int);
    void (*ls_link_in_service_at_level_2)(struct ls *, int);
    void (*ls_link_inhibited)(struct ls *, int);
    void (*ls_link_uninhibited)(struct ls *, int);
    void (*ls_local_inhibit_request)(struct ls *, int);
    void (*ls_message_for_distribution)(struct ls *, int, mblk_t *);
    void (*ls_message_for_routing)(struct ls *, int, mblk_t *);
    void (*ls_procedure_terminated)(struct ls *, int);
    void (*ls_remote_inhibit_request)(struct ls *, int);
    void (*ls_signalling_link_available)(struct ls *, int);
    void (*ls_signalling_link_unavailable)(struct ls *, int);
    void (*ls_slt_failed)(struct ls *, int);
    void (*ls_sslt_failed)(struct ls *, int);
    void (*ls_sslt_successful)(struct ls *, int);
    void (*ls_uninhibit_not_possible)(struct ls *, int);
    void (*ls_uninhibit_request)(struct ls *, int);
    void (*ls_uninhibiting_not_possible)(struct ls *, int);
} ls_ucalls_t;

typedef struct ls_dcalls {
    void (*ls_signal_unit)(struct ls *, int, mblk_t *);
    void (*ls_stop       )(struct ls *);
    void (*ls_start      )(struct ls *);
    void (*ls_restart    )(struct ls *);
    void (*ls_inhibit    )(struct ls *);
    void (*ls_uninhibit  )(struct ls *);
    void (*ls_emergency  )(struct ls *);
    void (*ls_normal     )(struct ls *);
} ls_dcalls_t;

typedef struct ls_mcalls {
    void (*sl_signal_unit)(struct ls *, int, mblk_t *);
    void (*sl_stop       )(struct ls *);
    void (*sl_start      )(struct ls *);
    void (*sl_restart    )(struct ls *);
    void (*sl_inhibit    )(struct ls *);
    void (*sl_uninhibit  )(struct ls *);
} ls_mcalls_t;

struct ls;

typedef struct ls_driver {
    struct ls_driver  *next;
    int               cmajor;
    int               nminor;
    struct ls         *list;
    struct streamtab  *info;
    struct lmi_ops    ops;
    struct lk_dcalls  *dcalls;
    struct lk_ucalls  *ucalls;
} ls_driver_t;

typedef lmi_option_t ls_option_t;

typedef struct ls_timers {
} ls_timers_t;

#define LS_MAX_TIMERIDS 0
#define LS_MAX_BUFCALLS 8

typedef ls_ulong ls_bufcid_t[LS_MAX_BUFCALLS];

typedef struct ls {
    struct ls        *next;      /* next device in device list       */
    struct mtpl      *module;
    struct ls_ucalls *ucalls;
    struct ls_mcalls *dcalls;
    struct lk        *device;    /* lower mux list */
    ls_driver_t      *driver;
    dev_t            devnum;
    queue_t          *rq;
    queue_t          *wq;
    ls_ulong         state;
    ls_ulong         flags;
    ls_ulong         ids[0];
    ls_timers_t      timers;
    ls_bufcid_t      bufids;
    ls_option_t      option;
    ls_config_t      config;
    ls_statem_t      statem;
    ls_stats_t       stats;
    ls_notify_t      notify;
} ls_t;

#endif  /* __KERNEL__ */

#endif  __SLS_H__
