/*****************************************************************************

 @(#) $Id: sls_hmcg.h,v 0.7.4.1 2001/02/18 09:44:36 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:36 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_HMCG_H__
#define __SLS_HMCG_H__

/*
 *  Referenced functions.
 */

static inline void ls_rtcc_hmcg_send_transfer_controlled_message(ls_t *ls, mblk_t *mp);
static inline void lk_l2_hmcg_message_for_transmission(lk_t *lk, mblk_t *mp);

/*
 *  Forward declarations.
 */

static inline void lk_hmcg_hmrt_message(lk_t *lk, mblk_t *mp);  /* from MTP */

/*
 *  Consistent with the link set and link portions of:
 *
 *      Signalling Message Handling (SMH)
 *      Signalling Link Congestion (HMCG)
 *      Figure 26a/Q.704
 *
 *  Note:- this state machine has only one state and is therefore just a
 *  collection of function calls.  These functions are only called by the MTP
 *  route set and route state machines and only recheck the link set and link
 *  congestion status to avoid transient conditions where the link congestion
 *  status has not yet been communicated to the sender.
 */

static inline void lk_hmcg_hmrt_message(lk_t *lk, mblk_t *mp)
{
    ls_t *ls = lk->module;
    ls_prim_t *p = (ls_prim_t *)mp->b_rptr;
    int P = p->sig.mh.mp;

    if ( P < ls->statem.cong_status || P < lk->statem.cong_status ) {
        ls_rtcc_hmcg_send_transfer_controlled_message(ls, mp);
        if ( P < ls->statem.disc_status || P < lk->statem.disc_status ) {
            freemsg(mp);
            return;
        }
    }
    if ( ls_build_msu(ls, mp) ) {
        /* encoding of the message was unsuccessful, discard and continue */
        /* we should log this error */
        freemsg(mp);
        return;
    }
    lk_l2_hmcg_message_for_transmission(lk, mp);
}



#endif  __SLS_HMCG_H__

