/*****************************************************************************

 @(#) $Id: sls_hmdc.h,v 0.7.4.1 2001/02/18 09:44:36 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:36 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_HMDC_H__
#define __SLS_HMDC_H__

/*
 *  This is the Signalling Link Set version of the HMDC state machine.  If the
 *  message is a management message which can be handled by the link set state
 *  machines it is handled here.  Otherwise, the message is forwarded to the
 *  MTP state machines.  In any case, the message is decoded to the extent
 *  that it can be determined whether the message is a management or user part
 *  message.  No other parsing of the received message is necessary.  If the
 *  message is passed on to the MTP for further discrimination, it is passed
 *  already parsed.
 */

/*
 *  Referenced functions.
 */

static inline void mtp_hmdt_hmdc_message_for_distribution(lk_t *lk, mblk_t *mp);
static inline void mtp_hmrt_hmdc_message_for_routing(lk_t *lk, mblk_t *mp);

static inline void lk_hmdt_hmdc_message_for_distribution(lk_t *lk, mblk_t *mp);

/*
 *  Forward declarations.
 */

static inline void lk_hmdc_l2_received_message(lk_t *lk, mblk_t *mp);

/*
 *  Consistent with:
 *
 *      Signalling Message Handling (SMH)
 *      Message Discrimination (HMDC)
 *      Figure 24/Q.704
 *      Figure 24/T1.111.4
 */

static inline void lk_hmdc_l2_received_message(lk_t *lk, mblk_t *mp)
{
    ls_prim_t *p;
    ls_t *ls = lk->module;

    if ( ls_parse_msu(ls, mp) ) {
        /* completely parses management messages and partially (header) parse other
         * messages */
        freemsg(mp);
        /* discard if parse fails - we may want to log or report this later */
        return;
    }
    p = (ls_prim_t *)mp->b_rptr;
    if ( ls->config.lpc == p->sig.mh.rl.dpc ) {
        if ( ls->config.apc == p->sig.mh.rl.opc )
            lk_hmdt_hmdc_message_for_distribution(lk, mp);
        else
            mtp_hmdt_hmdc_message_for_distribution(lk, mp);
    } else {
        if ( ls->statem.own_sp_restart ) {
            /* discard message during sp restart */
            freemsg(mp);
            return;
        } else
            mtp_hmrt_hmdc_message_for_routing(lk, mp);
    }
        
}



#endif  __SLS_HMDC_H__

