/*****************************************************************************

 @(#) $Id: sls_hmrt.h,v 0.7.4.1 2001/02/18 09:44:36 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:36 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_HMRT_H__
#define __SLS_HMRT_H__

/*
 *  Referenced functions.
 */

static inline void mtp_hmrt_xxxx_adjacent_sp_restart(ls_t *ls);

/*
 *  Forward declarations.
 */

static inline void ls_hmrt_xxxx_adjacent_sp_restart(ls_t *ls);
static inline void ls_hmrt_hmdc_message_for_routing(ls_t *ls, mblk_t *mp);
static inline void ls_hmrt_xxxx_signalling_link_management_message(ls_t *ls);
static inline void ls_hmrt_xxxx_signalling_route_management_message(ls_t *ls);
static inline void ls_hmrt_xxxx_mtp_testing_user_part_message(ls_t *ls);
static inline void ls_hmrt_tprc_restart_begins(ls_t *ls);
static inline void ls_hmrt_tprc_restart_ends(ls_t *ls);
static inline void ls_hmrt_xxxx_update_routing_tables(ls_t *ls);

static inline void lk_hmrt_lsda_signalling_data_link_connection_order(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_sltc_signalling_link_test_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_sltc_signalling_link_test_msg(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcbc_changeback_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcbc_changeback_declaration(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcbc_update_routing_tables(lk_t *lk);
static inline void lk_hmrt_tcoc_changeover_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcoc_changeover_order(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcoc_emergency_changeover_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcoc_emergency_changeover_order(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tcoc_update_routing_tables(lk_t *lk);
static inline void lk_hmrt_tlac_emergency_changeover_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_force_uninhibit_signalling_link(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_inhibit_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_inhibit_denied(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_inhibit_signalling_link(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_local_inhibit_test(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_remote_inhibit_test(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_uninhibit_ack(lk_t *lk, mblk_t *mp);
static inline void lk_hmrt_tlac_uninhibit_signalling_link(lk_t *lk, mblk_t *mp);

/*
 *  Consistent with link set and link functions of:
 *
 *      Signalling Message Handling (SMH)
 *      Message Routing (HMRT)
 *      Figure 26/Q.704
 *
 *  Note:- the HMRT state machine is a single state state machine which is
 *  best organized as a series of function calls and the interrogation of the
 *  ls->statem.own_sp_restart flag.  These link set and link functions are
 *  essentially subroutine calls made by the route set and route functions
 *  which are part of the MTPI.
 */


static inline void ls_hmrt_xxxx_adjacent_sp_restart(ls_t *ls)
{
    if ( !ls->statem.own_sp_restart ) {
        ls->statem.adjacent_sp_restart = 1;
        mtp_hmrt_xxxx_adjacent_sp_restart(ls);
    }
}

static inline void ls_hmrt_hmdc_message_for_routing(ls_t *ls, mblk_t *mp)
{
    ls_prim_t *p = (ls_prim_t *)mp->b_rptr;
    lk_t *lk = &ls->device[p->sig.mh.rl.sls];
    /*
     *  This function is called only by the MTP state machines (HMCG) to route
     *  a message once the link set has been selected.
     */
    lk_hmcg_hmrt_message(lk, mp);
}

static inline void ls_hmrt_xxxx_signalling_link_management_message(ls_t *ls)
{
}

static inline void ls_hmrt_xxxx_signalling_route_management_message(ls_t *ls)
{
}

static inline void ls_hmrt_xxxx_mtp_testing_user_part_message(ls_t *ls)
{
}

static inline void ls_hmrt_tprc_restart_begins(ls_t *ls)
{
}

static inline void ls_hmrt_tprc_restart_ends(ls_t *ls)
{
}

static inline void ls_hmrt_xxxx_update_routing_tables(ls_t *ls)
{
}


static inline void lk_hmrt_lsda_signalling_data_link_connection_order(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_sltc_signalling_link_test_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_sltc_signalling_link_test_msg(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcbc_changeback_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcbc_changeback_declaration(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcbc_update_routing_tables(lk_t *lk)
{
}

static inline void lk_hmrt_tcoc_changeover_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcoc_changeover_order(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcoc_emergency_changeover_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcoc_emergency_changeover_order(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tcoc_update_routing_tables(lk_t *lk)
{
}

static inline void lk_hmrt_tlac_emergency_changeover_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_force_uninhibit_signalling_link(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_inhibit_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_inhibit_denied(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_inhibit_signalling_link(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_local_inhibit_test(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_remote_inhibit_test(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_uninhibit_ack(lk_t *lk, mblk_t *mp)
{
}

static inline void lk_hmrt_tlac_uninhibit_signalling_link(lk_t *l, mblk_t *mpk)
{
}



#endif  __SLS_HMRT_H__

