/*****************************************************************************

 @(#) $Id: sls_lsla.h,v 0.7.4.1 2001/02/18 09:44:36 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:36 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_LSLA_H__
#define __SLS_LSLA_H__

/*
 *  Referenced functions.
 *
 *  This state machine accesses L1 functions.
 */

static inline void lk_l1_lsla_connect(lk_t *lk);

/* link and linkset functions */

static inline void lk_lsac_lsla_activation_not_possible(lk_t *lk);
static inline void lk_lsac_lsla_activation_unsuccessful(lk_t *lk);
static inline void lk_lsac_lsla_start_signalling_link(lk_t *lk);

static inline void lk_lsda_lsla_determine_data_link(lk_t *lk);

static inline void lk_lsta_lsla_determine_terminal(lk_t *lk);

/*
 *  Forward declarations.
 */

static inline void lk_lsla_lsac_deactivate_link(lk_t *lk);
static inline void lk_lsla_lsac_restart_activation(lk_t *lk);
static inline void lk_lsla_lsac_start_activation(lk_t *lk);

static inline void lk_lsla_lsda_data_link(lk_t *lk);
static inline void lk_lsla_lsda_no_data_link(lk_t *lk);

static inline void lk_lsla_lsta_no_terminal(lk_t *lk);
static inline void lk_lsla_lsta_terminal(lk_t *lk);

/*
 *  Signalling Link Management (SLM)
 *  Signalling Link Activate (LSLA)
 *  Figure 38/Q.704
 */

static inline void lk_lsla_lsac_start_activation(lk_t *lk)
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_IDLE:
            if ( lk->config.terminal_predetermined ) {
                lk_l1_lsla_connect(lk);
                lk_lsac_lsla_start_signalling_link(lk);
                lk->statem.terminal_determined = 0;
                lk->statem.data_link_determined = 0; /* error in SDL */
            } else {
                lk->statem.lsla_state = LK_STATE_WAIT;
                lk->statem.activation = 1;
                lk_lsta_lsla_determine_terminal(lk);
                if ( !lk->config.data_link_predetermined )
                    lk->statem.data_link_determined = 1;
                else {
                    lk->statem.activation = 1;
                    lk_lsda_lsla_determine_data_link(lk);
                }
            }
            break;
    }
}

static inline void lk_lsla_lsac_restart_activation(lk_t *lk)
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_IDLE:
            if ( !lk->config.data_link_predetermined ) {
                lk->statem.lsla_state = LK_STATE_WAIT;
                lk->statem.activation = 1;
                lk_lsda_lsla_determine_data_link(lk);
            } else {
                lk_lsac_lsla_activation_unsuccessful(lk);
                lk_lsac_lsla_start_signalling_link(lk);
            }
            break;
    }
}

static inline void __lk_lsla_determined(lk_t *lk)
{
    if ( lk->statem.terminal_determined && lk->statem.data_link_determined ) {
        lk->statem.lsla_state = LK_STATE_IDLE;
        lk_l1_lsla_connect(lk);
        lk_lsac_lsla_start_signalling_link(lk);
        lk->statem.terminal_determined = 0;
        lk->statem.data_link_determined = 0; /* error in SDL */
    }
}

static inline void lk_lsla_lsda_data_link(lk_t *lk)  /* called by MTP module */
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_WAIT:
            lk->statem.data_link_determined = 1;
            __lk_lsla_determined(lk);
            break;
    }
}

static inline void lk_lsla_lsta_terminal(lk_t *lk)   /* called by MTP module */
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_WAIT:
            lk->statem.terminal_determined = 1;
            __lk_lsla_determined(lk);
            break;
    }
}

static inline void lk_lsla_lsda_no_data_link(lk_t *lk)
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_WAIT:
            lk->statem.lsla_state = LK_STATE_IDLE;
            lk_lsac_lsla_activation_not_possible(lk);
            lk->statem.terminal_determined = 0;
            lk->statem.data_link_determined = 0; /* error in SDL */
            break;
    }
}

static inline void lk_lsla_lsta_no_terminal(lk_t *lk)    /* called by MTP module */
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_WAIT:
            lk->statem.lsla_state = LK_STATE_IDLE;
            lk_lsac_lsla_activation_not_possible(lk);
            lk->statem.terminal_determined = 0;
            lk->statem.data_link_determined = 0; /* error in SDL */
            break;
    }
}

static inline void lk_lsla_lsac_deactivate_link(lk_t *lk)
{
    switch ( lk->statem.lsla_state ) {
        case LK_STATE_WAIT:
            lk->statem.lsla_state = LK_STATE_IDLE;
            lk->statem.terminal_determined = 0;
            lk->statem.data_link_determined = 0; /* error in SDL */
            break;
    }
}

#endif  __SLS_LSLA_H__

