/*****************************************************************************

 @(#) $Id: sls_lsld.h,v 0.7.4.1 2001/02/18 09:44:37 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:37 $ by $Author: brian $

 *****************************************************************************/

#ifndef __LSLD_H__
#define __LSLD_H__

/*
 *  Referenced functions.
 *
 *  This state machine acesses L1 functions.
 */

static inline void lk_l1_lsld_disconnect(lk_t *lk);

/* link and linkset functions */

static inline void lk_lsda_lsld_data_link_available(lk_t *lk);

static inline void lk_lsta_lsld_terminal_idle(lk_t *lk);

/*
 *  Forward declarations.
 */

static inline void lk_lsld_lsac_deactivate_link(lk_t *lk);

/*
 *  Signalling Link Management (SLM)
 *  Signalling Link Deactivation (LSLD)
 *  Figure 40/Q.704
 */

static inline void lk_lsld_lsac_deactivate_link(lk_t *lk)
{
    lk_l1_lsld_disconnect(lk);
    lk_lsda_lsld_data_link_available(lk);
    lk_lsta_lsld_terminal_idle(lk);
}

#endif  __LSLD_H__

