/*****************************************************************************

 @(#) $Id: sls_lslr.h,v 0.7.4.1 2001/02/18 09:44:37 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:37 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_LSLR_H__
#define __SLS_LSLR_H__

/*
 *  Referenced functions.
 *
 *  This state machine accesses L1 functions.
 */

static inline void lk_l1_lslr_connect(lk_t *lk);

/* link and linkset functions */

static inline void lk_lsac_lslr_restoration_unsuccessful(lk_t *lk);
static inline void lk_lsac_lslr_start_signalling_link(lk_t *lk);

static inline void lk_lsda_lslr_determine_data_link(lk_t *lk);

static inline void lk_lsta_lslr_determine_terminal(lk_t *lk);

/*
 *  Forward declarations.
 */

static inline void lk_lslr_lsac_restart_restoration(lk_t *lk);
static inline void lk_lslr_lsac_start_restoration(lk_t *lk);

static inline void lk_lslr_lsda_data_link(lk_t *lk);
static inline void lk_lslr_lsda_no_data_link(lk_t *lk);

static inline void lk_lslr_lsta_no_terminal(lk_t *lk);
static inline void lk_lslr_lsta_terminal(lk_t *lk);

/*
 *  Signalling Link Management (SLM)
 *  Signalling Link Restoration (LSLR)
 *  Figure 39/Q.704
 */

static inline void lk_lslr_lsac_start_restoration(lk_t *lk)
{
    if ( lk->statem.lslr_state == LK_STATE_IDLE ) {
        lk_lsac_lslr_start_signalling_link(lk);
    }
}

static inline void lk_lslr_lsac_restart_restoration(lk_t *lk)
{
    if ( lk->statem.lslr_state == LK_STATE_IDLE ) {
        if ( lk->statem.replace_terminal ) {
            lk->statem.lslr_state = LK_STATE_WAIT_FOR_TERMINAL;
            lk->statem.restoration = 1;
            lk_lsta_lslr_determine_terminal(lk);
        } else
        if ( lk->statem.replace_data_link ) {
            lk->statem.lslr_state = LK_STATE_WAIT_FOR_DATA_LINK;
            lk->statem.restoration = 1;
            lk_lsda_lslr_determine_data_link(lk);
        } else {
            lk_lsac_lslr_restoration_unsuccessful(lk);
            lk_lsac_lslr_start_signalling_link(lk);
        }
    }
}

static inline void lk_lslr_lsta_terminal(lk_t *lk)
{
    if ( lk->statem.lslr_state == LK_STATE_WAIT_FOR_TERMINAL ) {
        lk->statem.lslr_state = LK_STATE_IDLE;
        lk_l1_lslr_connect(lk);
        lk_lsac_lslr_start_signalling_link(lk);
    }
}

static inline void lk_lslr_lsda_data_link(lk_t *lk)
{
    if ( lk->statem.lslr_state == LK_STATE_WAIT_FOR_DATA_LINK ) {
        lk->statem.lslr_state = LK_STATE_IDLE;
        lk_l1_lslr_connect(lk);
        lk_lsac_lslr_start_signalling_link(lk);
    }
}

static inline void lk_lslr_lsta_no_terminal(lk_t *lk) /* called by MTP module */
{
    if ( lk->statem.lslr_state == LK_STATE_WAIT_FOR_TERMINAL ) {
        lk->statem.lslr_state = LK_STATE_IDLE;
        lk_lsac_lslr_restoration_unsuccessful(lk);
        lk_lsac_lslr_start_signalling_link(lk);
    }
}

static inline void lk_lslr_lsda_no_data_link(lk_t *lk)
{
    if ( lk->statem.lslr_state == LK_STATE_WAIT_FOR_DATA_LINK ) {
        lk->statem.lslr_state = LK_STATE_IDLE;
        lk_lsac_lslr_restoration_unsuccessful(lk);
        lk_lsac_lslr_start_signalling_link(lk);
    }
}

#endif  __SLS_LSLR_H__

