/*****************************************************************************

 @(#) $Id: sls_parse.h,v 0.7.4.1 2001/02/18 09:44:37 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:37 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_PARSE_H__
#define __SLS_PARSE_H__

/*
 *  This is just a parsing support file for SS7 MTP messages.  It contains
 *  packed structure definitions for use by the message parser and builders
 *  for packing and unpacking SS7 MTP messages.
 */

struct __ansi_pc {
    unsigned network        __attribute__ ((packed));
    unsigned cluster        __attribute__ ((packed));
    unsigned member         __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_rl {
    unsigned dpc:24         __attribute__ ((packed));
    unsigned opc:24         __attribute__ ((packed));
    unsigned sls0:3         __attribute__ ((packed));
    unsigned sls:5          __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_mtph {
    unsigned si:4           __attribute__ ((packed));
    unsigned mp:2           __attribute__ ((packed));
    unsigned ni:2           __attribute__ ((packed));
    struct __ansi_rl rl     __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_mtpm {
    unsigned si:4           __attribute__ ((packed));
    unsigned mp:2           __attribute__ ((packed));
    unsigned ni:2           __attribute__ ((packed));
    struct __ansi_rl rl     __attribute__ ((packed));
    unsigned h0:4           __attribute__ ((packed));
    unsigned h1:4           __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_pc {
    unsigned network:4      __attribute__ ((packed));
    unsigned cluster:6      __attribute__ ((packed));
    unsigned member:4       __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_rl {
    unsigned dpc:14         __attribute__ ((packed));
    unsigned opc:14         __attribute__ ((packed));
    unsigned sls:4          __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_mtph {
    unsigned si:4           __attribute__ ((packed));
    unsigned mp:2           __attribute__ ((packed));
    unsigned ni:2           __attribute__ ((packed));
    struct __itut_rl rl     __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_mtpm {
    unsigned si:4           __attribute__ ((packed));
    unsigned mp:2           __attribute__ ((packed));
    unsigned ni:2           __attribute__ ((packed));
    struct __itut_rl rl     __attribute__ ((packed));
    unsigned h0:4           __attribute__ ((packed));
    unsigned h1:4           __attribute__ ((packed));
}                           __attribute__ ((packed));


struct __ansi_up {
    unsigned char pdu[1]    __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_up {
    unsigned char pdu[1]    __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_sltc {
    unsigned slc:4          __attribute__ ((packed));
    unsigned tli:4          __attribute__ ((packed));
    unsigned char tmsx[15]  __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_sltc {
    unsigned tli0:4         __attribute__ ((packed));
    unsigned tli:4          __attribute__ ((packed));
    unsigned char tmsx[15]  __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_cbm {
    unsigned slc:4          __attribute__ ((packed));
    unsigned cbc:8          __attribute__ ((packed));
    unsigned cbc0:4         __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_cbm {
    unsigned cbc:8          __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_com {
    unsigned slc:4          __attribute__ ((packed));
    unsigned fsnc:7         __attribute__ ((packed));
    unsigned fsnc0:5        __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_com {
    unsigned fsnc:7         __attribute__ ((packed));
    unsigned fsnc0:1        __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_slm {
    unsigned slc:4          __attribute__ ((packed));
    unsigned slc0:4         __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_slm {
}                           __attribute__ ((packed));

struct __ansi_tfc {
    unsigned dest:24        __attribute__ ((packed));
    unsigned stat:2         __attribute__ ((packed));
    unsigned stat0:6        __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_tfc {
    unsigned dest:14        __attribute__ ((packed));
    unsigned stat:2         __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_tfm {
    unsigned dest:14        __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_tfm {
    unsigned dest:14        __attribute__ ((packed));
    unsigned dest0:2        __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_ufc {
    unsigned dest:14        __attribute__ ((packed));
    unsigned upi:4          __attribute__ ((packed));
    unsigned upi0:4         __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_ufc {
    unsigned dest:14        __attribute__ ((packed));
    unsigned dest0:2        __attribute__ ((packed));
    unsigned upi:4          __attribute__ ((packed));
    unsigned upi0:4         __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __ansi_dlc {
    unsigned slc:4          __attribute__ ((packed));
    unsigned sdli:14        __attribute__ ((packed));
    unsigned sdli0:6        __attribute__ ((packed));
}                           __attribute__ ((packed));

struct __itut_dlc {
    unsigned sdli:14        __attribute__ ((packed));
    unsigned sdli0:2        __attribute__ ((packed));
}                           __attribute__ ((packed));

typedef struct __ansi_cbm   __ansi_cba;
typedef struct __ansi_cbm   __ansi_cbd;
typedef struct __ansi_slm   __ansi_cnp;
typedef struct __ansi_slm   __ansi_cns;
typedef struct __ansi_com   __ansi_coa;
typedef struct __ansi_com   __ansi_coo;
typedef struct __ansi_slm   __ansi_css;
typedef struct __ansi_dlc   __ansi_dlc;
typedef struct __ansi_slm   __ansi_eca;
typedef struct __ansi_slm   __ansi_eco;
typedef struct __ansi_slm   __ansi_lfu;
typedef struct __ansi_slm   __ansi_lia;
typedef struct __ansi_slm   __ansi_lid;
typedef struct __ansi_slm   __ansi_lin;
typedef struct __ansi_slm   __ansi_lli;
typedef struct __ansi_slm   __ansi_lri;
typedef struct __ansi_slm   __ansi_lua;
typedef struct __ansi_slm   __ansi_lun;
typedef struct __ansi_tfm   __ansi_rcp;
typedef struct __ansi_tfm   __ansi_rcr;
typedef struct {         }  __ansi_rct;
typedef struct __ansi_tfm   __ansi_rsp;
typedef struct __ansi_tfm   __ansi_rsr;
typedef struct __ansi_sltc  __ansi_slta;
typedef struct __ansi_sltc  __ansi_sltm;
typedef struct __ansi_sltc  __ansi_sslta;
typedef struct __ansi_sltc  __ansi_ssltm;
typedef struct __ansi_tfm   __ansi_tca;
typedef struct __ansi_tfm   __ansi_tcp;
typedef struct __ansi_tfm   __ansi_tcr;
typedef struct __ansi_tfm   __ansi_tfa;
typedef struct __ansi_tfc   __ansi_tfc;
typedef struct __ansi_tfm   __ansi_tfp;
typedef struct __ansi_tfm   __ansi_tfr;
typedef struct {         }  __ansi_tra;
typedef struct {         }  __ansi_trw;
typedef struct __ansi_ufc   __ansi_upa;
typedef struct __ansi_ufc   __ansi_upt;
typedef struct __ansi_ufc   __ansi_upu;
typedef struct __ansi_up    __ansi_dup1;
typedef struct __ansi_up    __ansi_dup2;
typedef struct __ansi_up    __ansi_isup;
typedef struct __ansi_up    __ansi_mtup;
typedef struct __ansi_up    __ansi_sccp;
typedef struct __ansi_up    __ansi_tup;
typedef struct __ansi_up    __ansi_tupe;
typedef struct __ansi_up    __ansi_tupp;
typedef struct __ansi_up    __ansi_up;

typedef struct __itut_cbm   __itut_cba;
typedef struct __itut_cbm   __itut_cbd;
typedef struct __itut_slm   __itut_cnp;
typedef struct __itut_slm   __itut_cns;
typedef struct __itut_com   __itut_coa;
typedef struct __itut_com   __itut_coo;
typedef struct __itut_slm   __itut_css;
typedef struct __itut_dlc   __itut_dlc;
typedef struct __itut_slm   __itut_eca;
typedef struct __itut_slm   __itut_eco;
typedef struct __itut_slm   __itut_lfu;
typedef struct __itut_slm   __itut_lia;
typedef struct __itut_slm   __itut_lid;
typedef struct __itut_slm   __itut_lin;
typedef struct __itut_slm   __itut_lli;
typedef struct __itut_slm   __itut_lri;
typedef struct __itut_slm   __itut_lua;
typedef struct __itut_slm   __itut_lun;
typedef struct __itut_tfm   __itut_rcp;
typedef struct __itut_tfm   __itut_rcr;
typedef struct {        }   __itut_rct;
typedef struct __itut_tfm   __itut_rsp;
typedef struct __itut_tfm   __itut_rsr;
typedef struct __itut_sltc  __itut_slta;
typedef struct __itut_sltc  __itut_sltm;
typedef struct __itut_sltc  __itut_sslta;
typedef struct __itut_sltc  __itut_ssltm;
typedef struct __itut_tfm   __itut_tca;
typedef struct __itut_tfm   __itut_tcp;
typedef struct __itut_tfm   __itut_tcr;
typedef struct __itut_tfm   __itut_tfa;
typedef struct __itut_tfc   __itut_tfc;
typedef struct __itut_tfm   __itut_tfp;
typedef struct __itut_tfm   __itut_tfr;
typedef struct {        }   __itut_tra;
typedef struct {        }   __itut_trw;
typedef struct __itut_ufc   __itut_upa;
typedef struct __itut_ufc   __itut_upt;
typedef struct __itut_ufc   __itut_upu;
typedef struct __itut_up    __itut_dup1;
typedef struct __itut_up    __itut_dup2;
typedef struct __itut_up    __itut_isup;
typedef struct __itut_up    __itut_mtup;
typedef struct __itut_up    __itut_sccp;
typedef struct __itut_up    __itut_tup;
typedef struct __itut_up    __itut_tupe;
typedef struct __itut_up    __itut_tupp;
typedef struct __itut_up    __itut_up;

union __ss7mtp_msg {
    struct {
        struct __itut_mtpm mh   __attribute__ ((packed));
        union {
            __itut_cba   cba    __attribute__ ((packed));
            __itut_cbd   cbd    __attribute__ ((packed));
            __itut_cnp   cnp    __attribute__ ((packed));
            __itut_cns   cns    __attribute__ ((packed));
            __itut_coa   coa    __attribute__ ((packed));
            __itut_coo   coo    __attribute__ ((packed));
            __itut_css   css    __attribute__ ((packed));
            __itut_dlc   dlc    __attribute__ ((packed));
            __itut_eca   eca    __attribute__ ((packed));
            __itut_eco   eco    __attribute__ ((packed));
            __itut_lfu   lfu    __attribute__ ((packed));
            __itut_lia   lia    __attribute__ ((packed));
            __itut_lid   lid    __attribute__ ((packed));
            __itut_lin   lin    __attribute__ ((packed));
            __itut_lli   lli    __attribute__ ((packed));
            __itut_lri   lri    __attribute__ ((packed));
            __itut_lua   lua    __attribute__ ((packed));
            __itut_lun   lun    __attribute__ ((packed));
            __itut_rcp   rcp    __attribute__ ((packed));
            __itut_rcr   rcr    __attribute__ ((packed));
            __itut_rct   rct    __attribute__ ((packed));
            __itut_rsp   rsp    __attribute__ ((packed));
            __itut_rsr   rsr    __attribute__ ((packed));
            __itut_slta  slta   __attribute__ ((packed));
            __itut_sltm  sltm   __attribute__ ((packed));
            __itut_sslta sslta  __attribute__ ((packed));
            __itut_ssltm ssltm  __attribute__ ((packed));
            __itut_tca   tca    __attribute__ ((packed));
            __itut_tcp   tcp    __attribute__ ((packed));
            __itut_tcr   tcr    __attribute__ ((packed));
            __itut_tfa   tfa    __attribute__ ((packed));
            __itut_tfc   tfc    __attribute__ ((packed));
            __itut_tfp   tfp    __attribute__ ((packed));
            __itut_tfr   tfr    __attribute__ ((packed));
            __itut_tra   tra    __attribute__ ((packed));
            __itut_trw   trw    __attribute__ ((packed));
            __itut_upa   upa    __attribute__ ((packed));
            __itut_upt   upt    __attribute__ ((packed));
            __itut_upu   upu    __attribute__ ((packed));
            __itut_dup1  dup1   __attribute__ ((packed));
            __itut_dup2  dup2   __attribute__ ((packed));
            __itut_isup  isup   __attribute__ ((packed));
            __itut_mtup  mtup   __attribute__ ((packed));
            __itut_sccp  sccp   __attribute__ ((packed));
            __itut_tup   tup    __attribute__ ((packed));
            __itut_tupe  tupe   __attribute__ ((packed));
            __itut_tupp  tupp   __attribute__ ((packed));
            __itut_up    up     __attribute__ ((packed));
        } msg                   __attribute__ ((packed));
    } itut                      __attribute__ ((packed));
    struct {
        struct __ansi_mtpm mh   __attribute__ ((packed));
        union {
            __ansi_cba   cba    __attribute__ ((packed));
            __ansi_cbd   cbd    __attribute__ ((packed));
            __ansi_cnp   cnp    __attribute__ ((packed));
            __ansi_cns   cns    __attribute__ ((packed));
            __ansi_coa   coa    __attribute__ ((packed));
            __ansi_coo   coo    __attribute__ ((packed));
            __ansi_css   css    __attribute__ ((packed));
            __ansi_dlc   dlc    __attribute__ ((packed));
            __ansi_eca   eca    __attribute__ ((packed));
            __ansi_eco   eco    __attribute__ ((packed));
            __ansi_lfu   lfu    __attribute__ ((packed));
            __ansi_lia   lia    __attribute__ ((packed));
            __ansi_lid   lid    __attribute__ ((packed));
            __ansi_lin   lin    __attribute__ ((packed));
            __ansi_lli   lli    __attribute__ ((packed));
            __ansi_lri   lri    __attribute__ ((packed));
            __ansi_lua   lua    __attribute__ ((packed));
            __ansi_lun   lun    __attribute__ ((packed));
            __ansi_rcp   rcp    __attribute__ ((packed));
            __ansi_rcr   rcr    __attribute__ ((packed));
            __ansi_rct   rct    __attribute__ ((packed));
            __ansi_rsp   rsp    __attribute__ ((packed));
            __ansi_rsr   rsr    __attribute__ ((packed));
            __ansi_slta  slta   __attribute__ ((packed));
            __ansi_sltm  sltm   __attribute__ ((packed));
            __ansi_sslta sslta  __attribute__ ((packed));
            __ansi_ssltm ssltm  __attribute__ ((packed));
            __ansi_tca   tca    __attribute__ ((packed));
            __ansi_tcp   tcp    __attribute__ ((packed));
            __ansi_tcr   tcr    __attribute__ ((packed));
            __ansi_tfa   tfa    __attribute__ ((packed));
            __ansi_tfc   tfc    __attribute__ ((packed));
            __ansi_tfp   tfp    __attribute__ ((packed));
            __ansi_tfr   tfr    __attribute__ ((packed));
            __ansi_tra   tra    __attribute__ ((packed));
            __ansi_trw   trw    __attribute__ ((packed));
            __ansi_upa   upa    __attribute__ ((packed));
            __ansi_upt   upt    __attribute__ ((packed));
            __ansi_upu   upu    __attribute__ ((packed));
            __ansi_dup1  dup1   __attribute__ ((packed));
            __ansi_dup2  dup2   __attribute__ ((packed));
            __ansi_isup  isup   __attribute__ ((packed));
            __ansi_mtup  mtup   __attribute__ ((packed));
            __ansi_sccp  sccp   __attribute__ ((packed));
            __ansi_tup   tup    __attribute__ ((packed));
            __ansi_tupe  tupe   __attribute__ ((packed));
            __ansi_tupp  tupp   __attribute__ ((packed));
            __ansi_up    up     __attribute__ ((packed));
        } msg                   __attribute__ ((packed));
    } ansi                      __attribute__ ((packed));
}                               __attribute__ ((packed));

typedef union __ss7mtp_msg mtp_msg_t;

#endif  __SLS_PARSE_H__
