/*****************************************************************************

 @(#) $Id: sls_sm.h,v 0.7.4.1 2001/02/18 09:44:37 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:37 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLS_SM_H__
#define __SLS_SM_H__

/*
 *  External referenced functions.
 */

/* sls_hmcg.h */
static inline void ls_rtcc_hmcg_send_transfer_controlled_message(ls_t *ls, mblk_t *mp);
static inline void lk_l2_hmcg_message_for_transmission(lk_t *lk, mblk_t *mp);

/* sls_hmdc.h */
static inline void mtp_hmdt_hmdc_message_for_distribution(ls_t *ls, mblk_t *mp);
static inline void mtp_hmrt_hmdc_message_for_routing(ls_t *ls, mblk_t *mp);

/* sls_hmdt.h */
static inline void mtp_hmdt_hmdc_message_for_distribution(ls_t *ls, mblk_t *mp);

/* sls_hmrt.h */
static inline void mtp_hmrt_xxxx_adjacent_sp_restart(ls_t *ls);

/* sls_llsc.h */

/* sls_lsac.h */

/* sls_lsda.h */
static inline void lk_tsrc_lsda_alternative_routing_data_request(lk_t *lk);

/* sls_lsla.h */
static inline void lk_l1_lsla_connect(lk_t *lk);

/* sls_lsld.h */
static inline void lk_l1_lsld_disconnect(lk_t *lk);

/* sls_lslr.h */
static inline void lk_l1_lslr_connect(lk_t *lk);

/* sls_lsta.h */

/* sls_sltc.h */
static inline void lk_mgmt_sltc_slt_failed(lk_t *lk);
static inline void lk_mgmt_sltc_sslt_failed(lk_t *lk);
static inline void lk_mgmt_sltc_sslt_successful(lk_t *lk);

/* sls_tcbc.h */
static inline void lk_tsrc_tcbc_alternative_routing_data_request(lk_t *lk);
static inline void lk_tsrc_tcbc_procedure_terminated(lk_t *lk);

/* sls_tcoc.h */
static inline void lk_tsrc_tcoc_alternative_routing_data_request(lk_t *lk);
static inline void lk_tsrc_tcoc_changeover_executed(lk_t *lk);
static inline void lk_tsrc_tcoc_changeover_not_required(lk_t *lk);

/* sls_tlac.h */
static inline void lk_mgmt_tlac_inhibit_denied(lk_t *lk);
static inline void lk_mgmt_tlac_link_inhibited(lk_t *lk);
static inline void lk_mgmt_tlac_link_uninhibited(lk_t *lk);
static inline void lk_mgmt_tlac_uninhibit_not_possible(lk_t *lk);
static inline void lk_mgmt_tlac_uninhibiting_not_possible(lk_t *lk);

static inline void lk_tsrc_tlac_cancel_link_inhibited(lk_t *lk);
static inline void lk_tsrc_tlac_link_in_service_at_level_2(lk_t *lk);
static inline void lk_tsrc_tlac_link_inhibited(lk_t *lk);
static inline void lk_tsrc_tlac_local_inhibit_request(lk_t *lk);
static inline void lk_tsrc_tlac_remote_inhibit_request(lk_t *lk);
static inline void lk_tsrc_tlac_signalling_link_available(lk_t *lk);
static inline void lk_tsrc_tlac_signalling_link_unavailable(lk_t *lk);
static inline void lk_tsrc_tlac_uninhibit_request(lk_t *lk);

static inline void lk_tprc_tlac_signalling_link_unavailable(lk_t *lk);

#endif  __SLS_SM_H__
