/*****************************************************************************

 @(#) $Id: devi_ioctl.h,v 0.7.4.1 2001/02/18 09:44:43 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:43 $ by $Author: brian $

 *****************************************************************************/

#ifndef __DEVI_IOCTL_H__
#define __DEVI_IOCTL_H__

#include <linux/ioctl.h>
#include <asm/spinlock.h>

#define DEV_IOC_MAGIC 'v'

/*
 *  DEVICE CONFIGURATION
 */

struct sdl;

#ifdef __KERNEL__

typedef struct dev_device {
    spinlock_t  iflock;     /* interface lock   */
    dev_ulong   ifflags;    /* interface flags  */
    dev_ulong   iftype;     /* interface type   */
    dev_ulong   ifgtype;    /* group type       */
    dev_ulong   ifmode;     /* interface mode   */
    dev_ulong   ifrate;     /* interface rate   */
    dev_ulong   ifclock;    /* interface clock  */
    dev_ulong   ifcoding;   /* interface coding */
    dev_ulong   ifleads;    /* interface leads  */
    dev_ulong   ifindex;    /* interface index  */
    dev_ulong   irq;        /* interrupt        */
    dev_ulong   iobase;     /* i/o base address */
    dev_ulong   dma_rx;     /* dma receive      */
    dev_ulong   dma_tx;     /* dma transmit     */
} dev_device_t;

#endif

#define DEV_IOCCIFRESET   _IO(  DEV_IOC_MAGIC,  0 )

#define DEV_IOCGIFFLAGS   _IOW( DEV_IOC_MAGIC,  1, dev_ulong )
#define DEV_IOCSIFFLAGS   _IOW( DEV_IOC_MAGIC,  2, dev_ulong )

#define DEV_IF_UP            0x00000001  /* device should set on enable  */
#define DEV_IF_RX_RUNNING    0x00000002  /* when Rx running              */
#define DEV_IF_TX_RUNNING    0x00000004  /* when Tx running              */
#define DEV_IF_SU_COMPRESS   0x00000008  /* when Rx compressing          */

#define DEV_IOCGIFTYPE    _IOR( DEV_IOC_MAGIC,  3, dev_ulong )
#define DEV_IOCSIFTYPE    _IOW( DEV_IOC_MAGIC,  4, dev_ulong )

enum {
    DEV_TYPE_NONE,
    DEV_TYPE_V35,
    DEV_TYPE_DS0,
    DEV_TYPE_DS0A,
    DEV_TYPE_E1,
    DEV_TYPE_T1,
    DEV_TYPE_J1,
    DEV_TYPE_ATM,
    DEV_TYPE_PACKET
};

#define DEV_IOCGGRPTYPE   _IOR( DEV_IOC_MAGIC,  5, dev_ulong )
#define DEV_IOCSGRPTYPE   _IOW( DEV_IOC_MAGIC,  6, dev_ulong )

enum {
    DEV_GTYPE_NONE,
    DEV_GTYPE_T1,
    DEV_GTYPE_E1,
    DEV_GTYPE_J1,
    DEV_GTYPE_ATM,
    DEV_GTYPE_ETH,
    DEV_GTYPE_IP,
    DEV_GTYPE_UDP,
    DEV_GTYPE_TCP,
    DEV_GTYPE_RTP,
    DEV_GTYPE_SCTP
};

#define DEV_IOCGIFMODE    _IOR( DEV_IOC_MAGIC,  7, dev_ulong )
#define DEV_IOCSIFMODE    _IOW( DEV_IOC_MAGIC,  8, dev_ulong )

enum {
    DEV_MODE_NONE,
    DEV_MODE_DSU,
    DEV_MODE_CSU,
    DEV_MODE_DTE,
    DEV_MODE_DCE,
    DEV_MODE_CLIENT,
    DEV_MODE_SERVER,
    DEV_MODE_PEER,
    DEV_MODE_ECHO,
    DEV_MODE_REM_LB,
    DEV_MODE_LOC_LB,
    DEV_MODE_LB_ECHO,
    DEV_MODE_TEST
};

#define DEV_IOCGIFRATE    _IOR( DEV_IOC_MAGIC,  9, dev_ulong )
#define DEV_IOCSIFRATE    _IOW( DEV_IOC_MAGIC, 10, dev_ulong )

#define DEV_IOCGIFCLOCK   _IOR( DEV_IOC_MAGIC, 11, dev_ulong )
#define DEV_IOCSIFCLOCK   _IOW( DEV_IOC_MAGIC, 12, dev_ulong )

enum {
    DEV_CLOCK_NONE,
    DEV_CLOCK_INT,
    DEV_CLOCK_EXT,
    DEV_CLOCK_LOOP,
    DEV_CLOCK_MASTER,
    DEV_CLOCK_SLAVE,
    DEV_CLOCK_DPLL,
    DEV_CLOCK_ABR,
    DEV_CLOCK_SHAPER,
    DEV_CLOCK_TICK
};

#define DEV_IOCGIFCODING  _IOR( DEV_IOC_MAGIC, 13, dev_ulong )
#define DEV_IOCSIFCODING  _IOW( DEV_IOC_MAGIC, 14, dev_ulong )

enum {
    DEV_CODING_NONE,
    DEV_CODING_NRZ,
    DEV_CODING_NRZI,
    DEV_CODING_AMI,
    DEV_CODING_B6ZS,
    DEV_CODING_B8ZS,
    DEV_CODING_ESF,     /* FIXME: this is actually a framing value */
    DEV_CODING_AAL1,
    DEV_CODING_AAL2,
    DEV_CODING_AAL5
};

#define DEV_IOCGIFLEADS   _IOR( DEV_IOC_MAGIC, 15, dev_ulong )
#define DEV_IOCSIFLEADS   _IOW( DEV_IOC_MAGIC, 16, dev_ulong )
#define DEV_IOCCIFLEADS   _IOW( DEV_IOC_MAGIC, 17, dev_ulong )

enum {
    DEV_LEAD_DTR = 0x01,    /* for V.35 DTR lead set or clr */
    DEV_LEAD_RTS = 0x02,    /* for V.35 RTS lead set or clr */
    DEV_LEAD_DCD = 0x04,    /* for V.35 DCD lead get */
    DEV_LEAD_CTS = 0x08,    /* for V.35 CTS lead get */
    DEV_LEAD_DSR = 0x10     /* for V.35 DSR lead get */
};

#define DEV_IOCCDISCTX    _IO(  DEV_IOC_MAGIC, 18 )
#define DEV_IOCCCONNTX    _IO(  DEV_IOC_MAGIC, 19 )

#define DEV_IOC_FIRST    0
#define DEV_IOC_LAST    19
#define DEV_IOC_PRIVATE 32

#endif  __DEVI_IOCTL_H__
