/*****************************************************************************

 @(#) $Id: isupi.h,v 0.7.4.1 2001/02/18 09:44:43 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last modified: $Date: 2001/02/18 09:44:43 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SS7_ISUPI_H__
#define __SS7_ISUPI_H__

typedef lmi_long    se_long;
typedef lmi_ulong   se_ulong;
typedef lmi_ushort  se_ushort;
typedef lmi_uchar   se_uchar;

typedef lmi_long    sp_long;
typedef lmi_ulong   sp_ulong;
typedef lmi_ushort  sp_ushort;
typedef lmi_uchar   sp_uchar;

#define SE_PROTO_BASE       128L

#define SE_DSTR_FIRST               (   1L + SE_PROTO_BASE )
#define SE_CONN_REQ                 (   1L + SE_PROTO_BASE )
#define SE_CONN_RES                 (   2L + SE_PROTO_BASE )
#define SE_DISCON_REQ               (   3L + SE_PROTO_BASE )
#define SE_DATA_REQ                 (   4L + SE_PROTO_BASE )
#define SE_EXDATA_REQ               (   5L + SE_PROTO_BASE )
#define SE_INFO_REQ                 (   6L + SE_PROTO_BASE )
#define SE_BIND_REQ                 (   7L + SE_PROTO_BASE )
#define SE_UNBIND_REQ               (   8L + SE_PROTO_BASE )
#define SE_UNITDATA_REQ             (   9L + SE_PROTO_BASE )
#define SE_OPTMGMT_REQ              (  10L + SE_PROTO_BASE )
#define SE_ORDREL_REQ               (  11L + SE_PROTO_BASE )
#define SE_DSTR_LAST                (  11L + SE_PROTO_BASE )

#define SE_USTR_FIRST               (  -1L - SE_PROTO_BASE )
#define SE_CONN_IND                 (  -1L - SE_PROTO_BASE )
#define SE_CONN_CON                 (  -2L - SE_PROTO_BASE )
#define SE_DISCON_IND               (  -3L - SE_PROTO_BASE )
#define SE_DATA_IND                 (  -4L - SE_PROTO_BASE )
#define SE_EXDATA_IND               (  -5L - SE_PROTO_BASE )
#define SE_INFO_ACK                 (  -6L - SE_PROTO_BASE )
#define SE_BIND_ACK                 (  -7L - SE_PROTO_BASE )
#define SE_ERROR_ACK                (  -8L - SE_PROTO_BASE )
#define SE_OK_ACK                   (  -9L - SE_PROTO_BASE )
#define SE_UNITDATA_IND             ( -10L - SE_PROTO_BASE )
#define SE_UDERROR_IND              ( -11L - SE_PROTO_BASE )
#define SE_OPTMGMT_ACK              ( -12L - SE_PROTO_BASE )
#define SE_ORDREL_IND               ( -13L - SE_PROTO_BASE )
#define SE_USTR_LAST                ( -13L - SE_PROTO_BASE )

/*
 *  SE_ISUP_MESSAGE_REQ, M_PROTO or M_PCPROTO, (w/ M_DATA)
 */

typedef struct {
    se_ulong    primitive;  /* SE_ISUP_MESSAGE_REQ */
    se_ulong    dpc;        /* Destination Point Code       */
    se_ulong    opc;        /* Origination Point Code       */
    se_ulong    sls;        /* Signalling Link Selection    */



#define


#endif  __SS7_ISUPI_H__
