/*****************************************************************************

 @(#) $Id: lmi_ioctl.h,v 0.7.4.1 2001/02/18 09:44:43 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:43 $ by $Author: brian $

 *****************************************************************************/

#ifndef __LMI_IOCTL_H__
#define __LMI_IOCTL_H__

/*
 *  COMMON IOCTL NUMBERS
 */

#define LMI_IOCGOPTIONS   0
#define LMI_IOCSOPTIONS   1
#define LMI_IOCGCONFIG    2
#define LMI_IOCSCONFIG    3
#define LMI_IOCTCONFIG    4
#define LMI_IOCCCONFIG    5
#define LMI_IOCGSTATEM    6
#define LMI_IOCCMRESET    7
#define LMI_IOCGSTATSP    8
#define LMI_IOCSSTATSP    9
#define LMI_IOCGSTATS    10
#define LMI_IOCCSTATS    11
#define LMI_IOCGNOTIFY   12
#define LMI_IOCSNOTIFY   13
#define LMI_IOCCNOTIFY   14
#define LMI_IOC_FIRST     0
#define LMI_IOC_LAST     14
#define LMI_IOC_PRIVATE  32

/*
 *  PROTOCOL VARIANT AND OPTIONS 
 */

typedef struct lmi_option {
    lmi_ulong   pvar;
    lmi_ulong   popt;
} lmi_option_t;

enum {
    SS7_PVAR_ITUT_88,  /* ITU-T protocol variant */
    SS7_PVAR_ITUT_93,  /* ITU-T protocol variant */
    SS7_PVAR_ITUT_96,  /* ITU-T protocol variant */
    SS7_PVAR_ITUT_00,  /* ITU-T protocol variant */
    SS7_PVAR_ANSI_88,  /* ANSI  protocol variant */
    SS7_PVAR_ANSI_92,  /* ANSI  protocol variant */
    SS7_PVAR_ANSI_96,  /* ANSI  protocol variant */
    SS7_PVAR_ANSI_00,  /* ANSI  protocol variant */
    SS7_PVAR_ETSI_88,  /* ETSI  protocol variant */
    SS7_PVAR_ETSI_93,  /* ETSI  protocol variant */
    SS7_PVAR_ETSI_96,  /* ETSI  protocol variant */
    SS7_PVAR_ETSI_00,  /* ETSI  protocol variant */
    SS7_PVAR_JTTC_94,  /* JTTC  protocol variant */
    SS7_PVAR_MAX = SS7_PVAR_JTTC_94
};

enum {
    SS7_POPT_MPLEV  = 0x00000001,   /* multiple priority/congestion levels  */
    SS7_POPT_PCR    = 0x00000002,   /* preventative cyclic retranlmission   */
    SS7_POPT_HSL    = 0x00000004,   /* high speed links                     */
    SS7_POPT_XSN    = 0x00000008,   /* extended sequence numbers            */
    SS7_POPT_ALL    = 0x0000000f    /* all options                          */
};

/*
 *  STATISTICS
 */

typedef struct lmi_sta {
    lmi_ulong   object_id;  /* object id for stats      */
    lmi_ulong   colperiod;  /* collection period        */
    lmi_ulong   timestamp;  /* timestamp end of period  */
} lmi_sta_t;

#endif  __LMI_IOCTL_H__
