/*****************************************************************************

 @(#) $Id: mtpi.h,v 0.7.4.1 2001/02/18 09:44:43 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last modified: $Date: 2001/02/18 09:44:43 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SS7_MTPI_H__
#define __SS7_MTPI_H__

typedef unsigned long  mtp_ulong;
typedef unsigned short mtp_ushort;
typedef unsigned char  mtp_uchar;

#define MTP_TRANSFER_REQ            0x00    /* MTP data transfer request */
#define MTP_TRANSFER_IND            0x01    /* MTP data transfer indication */
#define MTP_PAUSE_IND               0x02    /* MTP pause (stop) indication */
#define MTP_RESUME_IND              0x03    /* MTP resume (start) indication */
#define MTP_STATUS_IND              0x04    /* MTP status indication */
#define MTP_RESTART_COMPLETE_IND    0x05    /* MTP restart complete (impl. dep.) */

#define MTP_STATUS_TYPE_CONG        0x00    /* MTP-STATUS refers to convestion */
#define MTP_STATUS_TYPE_UPU         0x01

#define MTP_LEVEL_CONGESTION        0x00    /* Signalling network congested */
#define MTP_CAUSE_UPU_UNKNOWN       0x01    /* User part unavailable: unknown */
#define MTP_CAUSE_UPU_UNEQUIPPED    0x02    /* User part unavailable: unequipped remote user. */
#define MTP_CAUSE_UPU_INACCESSIBLE  0x03    /* User part unavailable: inaccessible remote user. */

#define MTP_CONGESTION_LEVEL0       0x00    /* Signalling network congestion level 0 */
#define MTP_CONGESTION_LEVEL1       0x01    /* Signalling network congestion level 1 */
#define MTP_CONGESTION_LEVEL2       0x02    /* Signalling network congestion level 2 */
#define MTP_CONGESTION_LEVEL3       0x03    /* Signalling network congestion level 3 */

/*
 *  MTP_TRANSFER_REQ, M_PROTO or M_PCPROTO
 */
typedef struct {
    mtp_ulong   mtp_opc;
    mtp_ulong   mtp_dpc;
    mtp_ushort  mtp_sls;
    mtp_ushort  mtp_sio;
} mtp_transfer_req_t;

/*
 *  MTP_TRANSFER_IND, M_PROTO or M_PCPROTO
 */
typedef struct {
    mtp_ulong   mtp_opc;
    mtp_ulong   mtp_dpc;
    mtp_ushort  mtp_sls;
    mtp_ushort  mtp_sio;
} mtp_transfer_ind_t;

typedef struct {
    mtp_ulong   mtp_affected_dpc;
} mtp_pause_ind_t;

typedef struct {
    mtp_ulong   mtp_affected_dpc;
} mtp_resume_ind_t;

/*
 *  8.1 Transfer
 *
 *  The primitive "MTP-TRANSFER" is used between level 4 and level 3 (SMH) to
 *  provide the MTP message transfer service.
 */

/*
 *  8.2 Pause
 *
 *  The primitive "MTP-PAUSE" indicates to "Users" the total inability of
 *  providing the MTP service to the specified destination (see 7.2.6).
 *
 *  NOTE -  The signalling point is inacessible via the MTP.  The MTP will
 *  determine when the signalling point is again acessible and send MTP-RESUME
 *  indication.  The user should wait for such an indication and, meanwhile is
 *  not allowed to send messages on that signalling point.  If the remote peer
 *  user is thought to be unavailable, that condition may be maintained or
 *  cancelled at the local user's discretion.
 */

/*
 *  8.3 Resume
 *
 *  The primitive MTP-RESUME indications to the "User" the ability of
 *  providing the MTP service to the specified destination (See 7.2.6)
 *
 *  This primitive corresponds to the destination accessible state as defined
 *  in Recommendation Q.704.
 *
 *  NOTE -  When the MTP-RESUME indicaiton is given to each user, the MTP does
 *          not know whether the remote peer user is available.  This is the
 *          responsibility of each user.
 */

/*
 *  8.4 Status
 *
 *  The primitive "MTP-STATUS" indicates to the "Users" the partial inability
 *  of providing the MTP service to the specified destination.  The primitive
 *  is also used to indicate to a User that a remote corresponding User is
 *  unavailable and the cause for unavailability (see 11.2.7/Q.704).
 *
 *  In the case of national option with congestion priorities or multiple
 *  signalling link congestion states without prioritites as in Recommendation
 *  Q.704 are implemented, this "MTP-STATUS" primitive is also used to
 *  indicate a change of congestion level.
 *
 *  This primitive corresponds to the destination congested/User Part
 *  unavailable states as defined in Recommendation Q.704.
 *
 *  NOTE -  In the case of remote user unavailability, the user is responsible
 *          for determining the availability of this peer user.  The user is
 *          cautioned not to send normal traffic to the peer user because,
 *          while such peer is unavailable, no message will be delivered but
 *          each will result in a repeated "MTP-STATUS" indication.  The MTP
 *          will not send any further indications about the unavailability or
 *          availability of this peer user unless the local user continues to
 *          send messages to the peer user.
 */

/*
 *  8.5 Restart
 *
 *  When the MTP restart procedure is terminated, the MTP indicates the end of
 *  MTP restart to all local MTP Users showing each signalling point's
 *  accessibility or inaccessibility.  The means of doing this is
 *  implementation dependent (see 9/Q.704).
 */

/*
 *  MTP_STATUS_IND, M_PROTO or M_PCPROTO
 */
typedef struct {
    mtp_ulong   mtp_affected_dpc;
    mtp_uchar   mtp_cause;
    mtp_uchar   mtp_level;
} mtp_status_ind_t;



typedef struct {
    mtp_ulong   dpc;
    mtp_ulong   opc;
    mtp_ulong   sls;
} mtp_rl_t;

typedef struct {
    mtp_uchar   si;
    mtp_uchar   mp;
    mtp_uchar   ni;
    mtp_rl_t    rl;
} mtp_hdr_t;

typedef struct {
    mtp_uchar   si;
    mtp_uchar   mp;
    mtp_uchar   ni;
    mtp_rl_t    rl;
    mtp_uchar   h0;
    mtp_uchar   h1;
} mtp_msu_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_COO */
    mtp_msu_t   mtp_msg;
    mtp_ulong   mtp_slc;
    mtp_ulong   mtp_fsnc;
} mtp_signal_coo_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_COA */
    mtp_msu_t   mtp_msg;
} mtp_signal_coa_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_CBD */
    mtp_msu_t   mtp_msg;
} mtp_signal_cbd_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_CBA */
    mtp_msu_t   mtp_msg;
} mtp_signal_cba_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_ECO */
    mtp_msu_t   mtp_msg;
} mtp_signal_eco_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_ECA */
    mtp_msu_t   mtp_msg;
} mtp_signal_eca_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_RCT */
    mtp_msu_t   mtp_msg;
} mtp_signal_rct_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_TFC */
    mtp_msu_t   mtp_msg;
} mtp_signal_tfc_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_TFP */
    mtp_msu_t   mtp_msg;
} mtp_signal_tfp_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_TFR */
    mtp_msu_t   mtp_msg;
} mtp_signal_tfr_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_TFA */
    mtp_msu_t   mtp_msg;
} mtp_signal_tfa_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_RSP */
    mtp_msu_t   mtp_msg;
} mtp_signal_rsp_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_RSR */
    mtp_msu_t   mtp_msg;
} mtp_signal_rsr_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LIN */
    mtp_msu_t   mtp_msg;
} mtp_signal_lin_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LUN */
    mtp_msu_t   mtp_msg;
} mtp_signal_lun_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LIA */
    mtp_msu_t   mtp_msg;
} mtp_signal_lia_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LUA */
    mtp_msu_t   mtp_msg;
} mtp_signal_lua_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LID */
    mtp_msu_t   mtp_msg;
} mtp_signal_lid_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LFU */
    mtp_msu_t   mtp_msg;
} mtp_signal_lfu_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LLT */
    mtp_msu_t   mtp_msg;
} mtp_signal_llt_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_LRT */
    mtp_msu_t   mtp_msg;
} mtp_signal_lrt_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_TRA */
    mtp_msu_t   mtp_msg;
} mtp_signal_tra_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_DLC */
    mtp_msu_t   mtp_msg;
} mtp_signal_dlc_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_CSS */
    mtp_msu_t   mtp_msg;
} mtp_signal_css_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_CNS */
    mtp_msu_t   mtp_msg;
} mtp_signal_cns_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_CNP */
    mtp_msu_t   mtp_msg;
} mtp_signal_cnp_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_UPU */
    mtp_msu_t   mtp_msg;
} mtp_signal_upu_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_SLTM */
    mtp_msu_t   mtp_msg;
} mtp_signal_sltm_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_SLTA */
    mtp_msu_t   mtp_msg;
} mtp_signal_slta_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_SSLTM */
    mtp_msu_t   mtp_msg;
} mtp_signal_ssltm_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_SSLTA */
    mtp_msu_t   mtp_msg;
} mtp_signal_sslta_t;

typedef struct {
    mtp_long    mtp_primitive;  /* MTP_MSU_REQ, MTP_MSU_IND */
    mtp_ulong   mtp_signal;     /* MTP_SIGNAL_USER */
    mtp_hdr_t   mtp_msg;
} mtp_signal_user_t;

typedef union {
    mtp_long            mtp_primitive;
    mtp_signal_user_t   msg;
    mtp_signal_coo_t    coo;
    mtp_signal_coa_t    coa;
    mtp_signal_cbd_t    cbd;
    mtp_signal_cba_t    cba;
    mtp_signal_eco_t    eco;
    mtp_signal_eca_t    eca;
    mtp_signal_rct_t    rct;
    mtp_signal_tfc_t    tfc;
    mtp_signal_tfp_t    tfp;
    mtp_signal_tfr_t    tfr;
    mtp_signal_tfa_t    tfa;
    mtp_signal_rsp_t    rsp;
    mtp_signal_rsr_t    rsr;
    mtp_signal_lin_t    lin;
    mtp_signal_lun_t    lun;
    mtp_signal_lia_t    lia;
    mtp_signal_lua_t    lua;
    mtp_signal_lid_t    lid;
    mtp_signal_lfu_t    lfu;
    mtp_signal_llt_t    llt;
    mtp_signal_lrt_t    lrt;
    mtp_signal_tra_t    tra;
    mtp_signal_dlc_t    dlc;
    mtp_signal_css_t    css;
    mtp_signal_cns_t    cns;
    mtp_signal_cnp_t    cnp;
    mtp_signal_upu_t    upu;
    mtp_signal_sltm_t   sltm;
    mtp_signal_slta_t   slta;
    mtp_signal_ssltm_t  ssltm;
    mtp_signal_sslta_t  sslta;
    mtp_signal_user_t   user;
} MTP_signals;

/*
 *  MTP_MSU_REQ , M_PROTO or M_PCPROTO (M_DATA)
 */
typedef MTP_signals
mtp_msu_req_t;
/*
 *  MTP_MSU_IND , M_PROTO or M_PCPROTO (M_DATA)
 */
typedef MTP_signals
mtp_msu_ind_t;

#define MTP_SIGNAL_NONE      0
#define MTP_SIGNAL_COO       1      /* STM */
#define MTP_SIGNAL_COA       2      /* STM */
#define MTP_SIGNAL_CBD       3      /* STM */
#define MTP_SIGNAL_CBA       4      /* STM */
#define MTP_SIGNAL_ECO       5      /* STM */
#define MTP_SIGNAL_ECA       6      /* STM */
#define MTP_SIGNAL_LIN      14      /* STM */
#define MTP_SIGNAL_LUN      15      /* STM */
#define MTP_SIGNAL_LIA      16      /* STM */
#define MTP_SIGNAL_LUA      17      /* STM */
#define MTP_SIGNAL_LID      18      /* STM */
#define MTP_SIGNAL_LFU      19      /* STM */
#define MTP_SIGNAL_LLT      20      /* STM */
#define MTP_SIGNAL_LRT      21      /* STM */
#define MTP_SIGNAL_TRA      22      /* STM */

#define MTP_SIGNAL_RCT       7      /* SRM */
#define MTP_SIGNAL_TFC       8      /* SRM */
#define MTP_SIGNAL_TFP       9      /* SRM */
#define MTP_SIGNAL_TFR      10      /* SRM */
#define MTP_SIGNAL_TFA      11      /* SRM */
#define MTP_SIGNAL_RSP      12      /* SRM */
#define MTP_SIGNAL_RSR      13      /* SRM */
#define MTP_SIGNAL_UPU      27      /* SRM */

#define MTP_SIGNAL_DLC      23      /* SLM */
#define MTP_SIGNAL_CSS      24      /* SLM */
#define MTP_SIGNAL_CNS      25      /* SLM */
#define MTP_SIGNAL_CNP      26      /* SLM */

#define MTP_SIGNAL_SLTM     28      /* SLTC */
#define MTP_SIGNAL_SLTA     29      /* SLTC */
#define MTP_SIGNAL_SSLTM    30      /* SLTC */
#define MTP_SIGNAL_SSLTA    31      /* SLTC */

#define MTP_SIGNAL_USER     32      /* L4 */

#endif  __SS7_MTPI_H__
