/*****************************************************************************

 @(#) $Id: mtpi_ioctl.h,v 0.7.4.1 2001/02/18 09:44:43 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:43 $ by $Author: brian $

 *****************************************************************************/

#ifndef __MTPI_IOCTL_H__
#define __MTPI_IOCTL_H__

#include <linux/ioctl.h>

#define MTP_IOC_MAGIC 'm'

/*
 *  PROTOCOL VARIANT AND OPTIONS
 */

#define MTP_IOCGOPTION  _IOR(   MTP_IOC_MAGIC,  0,  lmi_ioption_t )
#define MTP_IOCSOPTION  _IOW(   MTP_IOC_MAGIC,  1,  lmi_ioption_t )

/*
 *  CONFIGURATION
 */

typedef struct mtp_config {
} mtp_config_t;

#define MTP_IOCGCONFIG  _IOR(   MTP_IOC_MAGIC,  2,  mtp_config_t )
#define MTP_IOCSCONFIG  _IOWR(  MTP_IOC_MAGIC,  3,  mtp_config_t )
#define MTP_IOCTCONFIG  _IOWR(  MTP_IOC_MAGIC,  4,  mtp_config_t )
#define MTP_IOCCCONFIG  _IOR(   MTP_IOC_MAGIC,  5,  mtp_config_t )

/*
 *  STATE
 */

typedef struct mtp_statem {
} mtp_statem_t;

#define MTP_IOCGSTATEM  _IOR(   MTP_IOC_MAGIC,  6,  mtp_statem_t )
#define MTP_IOCCMRESET  _IOR(   MTP_IOC_MAGIC,  7,  mtp_statem_t )

/*
 *  STATISTICS
 */

typedef struct mtp_stats {
    lmi_ulong   header;
} mtp_stats_t;

#define MTP_IOCGSTATSP  _IOR(   MTP_IOC_MAGIC,  8,  mtp_stats_t )
#define MTP_IOCSSTATSP  _IOWR(  MTP_IOC_MAGIC,  9,  mtp_stats_t )
#define MTP_IOCGSTATS   _IOR(   MTP_IOC_MAGIC, 10,  mtp_stats_t )
#define MTP_IOCSSTATS   _IOW(   MTP_IOC_MAGIC, 11,  mtp_stats_t )

/*
 *  EVENTS
 */

typedef struct mtp_notify {
    mtp_ulong   mtp_notifications;
} mtp_notify_t;

#define MTP_IOCGNOTIFY  _IOR(   MTP_IOC_MAGIC,  12, mtp_notify_t )
#define MTP_IOCSNOTIFY  _IOW(   MTP_IOC_MAGIC,  13, mtp_notify_t )
#define MTP_IOCCNOTIFY  _IOW(   MTP_IOC_MAGIC,  14, mtp_notify_t )

#define MTP_IOC_FIRST    0
#define MTP_IOC_LAST    14
#define MTP_IOC_PRIVATE 32

#endif  __MTPI_IOCTL_H__
