/*****************************************************************************

 @(#) $Id: sctpi_ioctl.h,v 0.7.4.1 2001/02/18 09:44:43 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:43 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SCTPI_IOCTL_H__
#define __SCTPI_IOCTL_H__

#define SCTP_IOC_MAGIC 'c'

/*
 *  PROTOCOL VARIANT AND OPTIONS
 */

#define SCTP_IOCCOPTIONS _IOR(  SCTP_IOC_MAGIC, 0, lmi_option_t )
#define SCTP_IOCSOPTIONS _IOW(  SCTP_IOC_MAGIC, 1, lmi_option_t )

/*
 *  CONFIGURATION
 */
typedef struct sctp_config {
} sctp_config_t;

#define SCTP_IOCGCONFIG  _IOWR( SCTPIOC_MAGIC, 2, sctp_config_t )
#define SCTP_IOCSCONFIG  _IOWR( SCTPIOC_MAGIC, 3, sctp_config_t )
#define SCTP_IOCTCONFIG  _IOWR( SCTPIOC_MAGIC, 4, sctp_config_t )
#define SCTP_IOCCCONFIG  _IOWR( SCTPIOC_MAGIC, 5, sctp_config_t )

/*
 *  STATE
 */

typedef struct sctp_statem {
} sctp_statem_t;

#define SCTP_STATE_CLOSED               0
#define SCTP_STATE_COOKIE_WAIT          1
#define SCTP_STATE_COOKIE_ECHOED        2
#define SCTP_STATE_ESTABLISHED          3
#define SCTP_STATE_SHUTDOWN_RECEIVED    4
#define SCTP_STATE_SHUTDOWN_PENDING     5
#define SCTP_STATE_SHUTDOWN_SENT        6
#define SCTP_STATE_SHUTDOWN_ACK_SENT    7

#define SCTP_IOCGSTATEM  _IOR(  SCTP_IOC_MAGIC, 6, sctp_statem_t )
#define SCTP_IOCCMRESET  _IOR(  SCTP_IOC_MAGIC, 7, sctp_statem_t )

/*
 *  STATISTICS
 */

typedef struct sctp_stats {
} sctp_stats_t;

#define SCTP_IOCGSTATSP  _IOR(  SCTP_IOC_MAGIC,  8, lmi_sta_t )
#define SCTP_IOCSSTATSP  _IORW( SCTP_IOC_MAGIC,  9, lmi_sta_t )
#define SCTP_IOCGSTATS   _IOR(  SCTP_IOC_MAGIC, 10, sctp_stats_t )
#define SCTP_IOCCSTATS   _IOW(  SCTP_IOC_MAGIC, 11, sctp_stats_t )

/*
 *  NOTIFICATIONS
 */

typedef struct sctp_notify {
    sctp_ulong    events;
} sctp_notify_t;

#define SCTP_EVENT_HEADER_LEN         16  /* for now */

#define SCTP_IOCGNOTIFY  _IOR(  SCTP_IOC_MAGIC, 12, sctp_notify_t )
#define SCTP_IOCSNOTIFY  _IOW(  SCTP_IOC_MAGIC, 13, sctp_notify_t )
#define SCTP_IOCCNOTIFY  _IOW(  SCTP_IOC_MAGIC, 14, sctp_notify_t )

#define SCTP_IOC_FIRST     0
#define SCTP_IOC_LAST     14
#define SCTP_IOC_PRIVATE  32

#endif  __SCTPI_IOCTL_H__

