/*****************************************************************************

 @(#) $Id: sdli.h,v 0.7.4.1 2001/02/18 09:44:44 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:44 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SDLI_H__
#define __SDLI_H__

/*
 *  The purpose of the SDL interface is to provide separation between the
 *  SDTI (Signalling Data Terminal Interface) which provides SS7 Signalling
 *  Data Terminal (SDT) state machine services including AERM, SUERM and
 *  EIM, and the underlying driver which provides essentially HDLC
 *  capabilities (DAEDR and DAEDT).  The interface utilizes some FISU/LSSU
 *  compression techniques to increase the performance of the interface.
 */

typedef lmi_long    sdl_long;
typedef lmi_ulong   sdl_ulong;
typedef lmi_ushort  sdl_ushort;
typedef lmi_uchar   sdl_uchar;

#define SDL_PROTO_BASE                     16L

#define SDL_DSTR_FIRST                     ( 1L + SDL_PROTO_BASE)
#define SDL_DAEDT_TRANSMISSION_REQ         ( 1L + SDL_PROTO_BASE)
#define SDL_DAEDT_START_REQ                ( 2L + SDL_PROTO_BASE)
#define SDL_DAEDR_START_REQ                ( 3L + SDL_PROTO_BASE)
#define SDL_DSTR_LAST                      ( 3L + SDL_PROTO_BASE)

#define SDL_USTR_LAST                      (-1L - SDL_PROTO_BASE)
#define SDL_DAEDR_RECEIVED_BITS_IND        (-1L - SDL_PROTO_BASE)
#define SDL_DAEDR_CORRECT_SU_IND           (-2L - SDL_PROTO_BASE)
#define SDL_DAEDR_SU_IN_ERROR_IND          (-3L - SDL_PROTO_BASE)
#define SDL_DAEDT_TRANSMISSION_REQUEST_IND (-4L - SDL_PROTO_BASE)
#define SDL_USTR_FIRST                     (-4L - SDL_PROTO_BASE)

/*
 *  SDLI PROTOCOL PRIMITIVES
 */

/*
 *  SDL_DAEDR_RECEIVED_BITS_IND, M_PROTO, M_PCPROTO or M_DATA
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDR_RECEIVED_BITS_IND */
    sdl_ulong   sdl_count;
} sdl_daedr_received_bits_ind_t;

/*
 *  SDL_DAEDR_START_REQ, M_PROTO or M_PCPROTO
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDR_START_REQ */
} sdl_daedr_start_req_t;

/*
 *  SDL_DAEDR_CORRECT_SU_IND, M_PROTO or M_PCPROTO
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDR_CORRECT_SU_IND */
    sdl_ulong   sdl_count;
} sdl_daedr_correct_su_ind_t;

/*
 *  SDL_DAEDR_SU_IN_ERROR_IND, M_PROTO or M_PCPROTO
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDR_SU_IN_ERROR_IND */
} sdl_daedr_su_in_error_ind_t;

/*
 *  SDL_DAEDT_START_REQ, M_PROTO or M_PCPROTO
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDT_START_REQ */
} sdl_daedt_start_req_t;

/*
 *  SDL_DAEDT_TRANSMISSION_REQ, M_PROTO, M_PCPROTO or M_DATA
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDT_TRANSMISSION_REQ */
} sdl_daedt_transmission_req_t;

/*
 *  SDL_DAEDT_TRANSMISSION_REQUEST_IND, M_PROTO, M_PCPROTO
 */
typedef struct {
    sdl_long    sdl_primitive;  /* SDL_DAEDT_TRANSMISSSION_REQUEST_IND */
} sdl_daedt_transmission_request_ind_t;

union SDL_primitives {
    sdl_long                                sdl_primitive;
    sdl_daedr_received_bits_ind_t           daedr_received_bits_ind;
    sdl_daedr_start_req_t                   daedr_start_req;
    sdl_daedr_correct_su_ind_t              daedr_correct_su_ind;
    sdl_daedr_su_in_error_ind_t             daedr_su_in_error_ind;
    sdl_daedt_start_req_t                   daedt_start_req;
    sdl_daedt_transmission_req_t            daedt_transmission_req;
    sdl_daedt_transmission_request_ind_t    daedt_transmission_request_ind;
};

#define SDL_DAEDR_RECEIVED_BITS_IND_SIZE        sizeof(sdl_daedr_received_bits_ind_t)
#define SDL_DAEDR_START_REQ_SIZE                sizeof(sdl_daedr_start_req_t)
#define SDL_DAEDR_CORRECT_SU_IND_SIZE           sizeof(sdl_daedr_correct_su_ind_t)
#define SDL_DAEDR_SU_IN_ERROR_IND_SIZE          sizeof(sdl_daedr_su_in_error_ind_t)
#define SDL_DAEDT_START_REQ_SIZE                sizeof(sdl_daedt_start_req_t)
#define SDL_DAEDT_TRANSMISSION_REQ_SIZE         sizeof(sdl_daedt_transmission_req_t)
#define SDL_DAEDT_TRANSMISSION_REQUEST_IND_SIZE sizeof(sdl_daedt_transmission_request_ind_t)

#endif  __SDLI_H__
