/*****************************************************************************

 @(#) $Id: sdli_ioctl.h,v 0.7.4.1 2001/02/18 09:44:44 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:44 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SDLI_IOCTL_H__
#define __SDLI_IOCTL_H__

#include <linux/ioctl.h>

#define SDL_IOC_MAGIC 'd'

/*
 *  PROTOCOL VARIANT AND OPTIONS
 */

#define SDL_IOCGOPTIONS _IOR(  SDL_IOC_MAGIC,  0, lmi_option_t )
#define SDL_IOCSOPTIONS _IOW(  SDL_IOC_MAGIC,  1, lmi_option_t )

/*
 *  CONFIGURATION
 */

typedef struct sdl_config {
    sdl_ulong   N;      /* octets per su in octet-counting mode */
    sdl_ulong   m;      /* maximum SIF size                     */
} sdl_config_t;

#define SDL_IOCGCONFIG  _IOR(  SDL_IOC_MAGIC,  2, sdl_config_t )
#define SDL_IOCSCONFIG  _IOWR( SDL_IOC_MAGIC,  3, sdl_config_t )
#define SDL_IOCTCONFIG  _IOWR( SDL_IOC_MAGIC,  4, sdl_config_t )
#define SDL_IOCCCONFIG  _IOR(  SDL_IOC_MAGIC,  5, sdl_config_t )

/*
 *  STATE
 */

typedef struct sdl_statem {
    sdl_ulong   daedt_state;
    sdl_ulong   daedr_state;
    sdl_ulong   octet_counting_mode;
} sdl_statem_t;

#define SDL_STATE_IDLE          0x00
#define SDL_STATE_IN_SERVICE    0x01

#define SDL_IOCGSTATEM  _IOR(  SDL_IOC_MAGIC,  6, sdl_statem_t )
#define SDL_IOCCMRESET  _IOR(  SDL_IOC_MAGIC,  7, sdl_statem_t )

/*
 *  STATISTICS
 */

typedef struct sdl_stats {
    lmi_ulong   header;
    sdl_ulong   rx_bytes;
    sdl_ulong   tx_bytes;
    sdl_ulong   rx_sus;
    sdl_ulong   tx_sus;
    sdl_ulong   rx_overruns;
    sdl_ulong   tx_underruns;
    sdl_ulong   rx_aborts;
    sdl_ulong   tx_aborts;
    sdl_ulong   rx_buffer_overflows;
    sdl_ulong   tx_buffer_overflows;
    sdl_ulong   rx_sus_in_error;            /* Q.752 Table 1.8  5,30 min */
    sdl_ulong   tx_sus_in_error;
    sdl_ulong   rx_sync_transitions;
    sdl_ulong   rx_bits_octet_counted;
    sdl_ulong   rx_crc_errors;
    sdl_ulong   rx_frame_errors;
    sdl_ulong   rx_frame_overflows;
    sdl_ulong   rx_frame_too_long;
    sdl_ulong   rx_frame_too_short;
    sdl_ulong   rx_residue_errors;
    sdl_ulong   rx_length_error;            /* error in length indicator */
    sdl_ulong   lead_cts_lost;
    sdl_ulong   lead_dcd_lost;
    sdl_ulong   carrier_lost;
} sdl_stats_t;

#define SDL_IOCGSTATSP  _IOR(  SDL_IOC_MAGIC,  8, sdl_stats_t  )
#define SDL_IOCSSTATSP  _IOWR( SDL_IOC_MAGIC,  9, sdl_stats_t  )
#define SDL_IOCGSTATS   _IOR(  SDL_IOC_MAGIC, 10, sdl_stats_t  )
#define SDL_IOCCSTATS   _IOW(  SDL_IOC_MAGIC, 11, sdl_stats_t  )

/*
 *  EVENTS
 */
typedef struct sdl_notify {
    sdl_ulong   sdl_notifications;
} sdl_notify_t;

#define SDL_EVT_LOST_SYNC   0x0000001
#define SDL_EVT_SU_ERROR    0x0000002
#define SDL_EVT_TX_FAIL     0x0000004
#define SDL_EVT_RX_FAIL     0x0000008

#define SDL_IOCGNOTIFY  _IOR(  SDL_IOC_MAGIC, 12, sdl_notify_t )
#define SDL_IOCSNOTIFY  _IOW(  SDL_IOC_MAGIC, 13, sdl_notify_t )
#define SDL_IOCCNOTIFY  _IOW(  SDL_IOC_MAGIC, 14, sdl_notify_t )

#define SDL_IOC_FIRST    0
#define SDL_IOC_LAST    14
#define SDL_IOC_PRIVATE 32

#endif  __SDLI_IOCTL_H__
