/*****************************************************************************

 @(#) $Id: sli.h,v 0.7.4.1 2001/02/18 09:44:44 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:44 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SS7_SLI_H__
#define __SS7_SLI_H__

typedef lmi_long    sl_long;
typedef lmi_ulong   sl_ulong;
typedef lmi_ushort  sl_ushort;
typedef lmi_uchar   sl_uchar;

#define SL_PROTO_BASE                       48L

#define SL_DSTR_FIRST                      (  1L + SL_PROTO_BASE)
#define SL_PDU_REQ                         (  1L + SL_PROTO_BASE)
#define SL_EMERGENCY_REQ                   (  2L + SL_PROTO_BASE)
#define SL_EMERGENCY_CEASES_REQ            (  3L + SL_PROTO_BASE)
#define SL_START_REQ                       (  4L + SL_PROTO_BASE)
#define SL_STOP_REQ                        (  5L + SL_PROTO_BASE)
#define SL_RETRIEVE_BSNT_REQ               (  6L + SL_PROTO_BASE)
#define SL_RETRIEVAL_REQUEST_AND_FSNC_REQ  (  7L + SL_PROTO_BASE)
#define SL_RESUME_REQ                      (  8L + SL_PROTO_BASE)
#define SL_CLEAR_BUFFERS_REQ               (  9L + SL_PROTO_BASE)
#define SL_LOCAL_PROCESSOR_OUTAGE_REQ      ( 10L + SL_PROTO_BASE)
#define SL_CONGESTION_DISCARD_REQ          ( 11L + SL_PROTO_BASE)
#define SL_CONGESTION_ACCEPT_REQ           ( 12L + SL_PROTO_BASE)
#define SL_NO_CONGESTION_REQ               ( 13L + SL_PROTO_BASE)
#define SL_POWER_ON_REQ                    ( 14L + SL_PROTO_BASE)
#define SL_DSTR_LAST                       ( 14L + SL_PROTO_BASE)

#define SL_USTR_LAST                       ( -1L - SL_PROTO_BASE)
#define SL_PDU_IND                         ( -1L - SL_PROTO_BASE)
#define SL_LINK_CONGESTED_IND              ( -2L - SL_PROTO_BASE)
#define SL_LINK_CONGESTION_CEASED_IND      ( -3L - SL_PROTO_BASE)
#define SL_RETRIEVED_MESSAGE_IND           ( -4L - SL_PROTO_BASE)
#define SL_RETRIEVAL_COMPLETE_IND          ( -5L - SL_PROTO_BASE)
#define SL_RB_CLEARED_IND                  ( -6L - SL_PROTO_BASE)
#define SL_BSNT_IND                        ( -7L - SL_PROTO_BASE)
#define SL_IN_SERVICE_IND                  ( -8L - SL_PROTO_BASE)
#define SL_OUT_OF_SERVICE_IND              ( -9L - SL_PROTO_BASE)
#define SL_REMOTE_PROCESSOR_OUTAGE_IND     (-10L - SL_PROTO_BASE)
#define SL_REMOTE_PROCESSOR_RECOVERED_IND  (-11L - SL_PROTO_BASE)
#define SL_RTB_CLEARED_IND                 (-12L - SL_PROTO_BASE)
#define SL_USTR_FIRST                      (-12L - SL_PROTO_BASE)

/*
 *  SLI PROTOCOL PRIMITIVES
 */

/*
 *  SL_PDU_REQ, optional M_PROTO type, with M_DATA block(s)
 */
typedef struct {
    sl_long     sl_primitive;
} sl_pdu_req_t;

/*
 *  SL_PDU_IND, optional M_PROTO type, with M_DATA block(s)
 */
typedef struct {
    sl_long     sl_primitive;
} sl_pdu_ind_t;

/*
 *  PROTOCOL CONTROL PRIMITIVES
 */

/*
 *  SL_EMERGENCY_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_emergency_req_t;

/*
 *  SL_EMERGENCY_CEASES_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_emergency_ceases_req_t;

/*
 *  SL_START_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_start_req_t;

/*
 *  SL_STOP_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_stop_req_t;

/*
 *  SL_RETRIEVE_BSNT_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_retrieve_bsnt_req_t;

/*
 *  SL_RETRIEVAL_REQUEST_AND_FSNC_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_fsnc;
} sl_retrieval_req_and_fsnc_t;

/*
 *  SL_RESUME_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_resume_req_t;

/*
 *  SL_CLEAR_BUFFERS_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_clear_buffers_req_t;

/*
 *  SL_LOCAL_PROCESSOR_OUTAGE_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_local_proc_outage_req_t;

/*
 *  SL_CONGESTION_DISCARD_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_cong_discard_req_t;

/*
 *  SL_CONGESTION_ACCEPT_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_cong_accept_req_t;

/*
 *  SL_NO_CONGESTION_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_no_cong_req_t;

/*
 * SL_POWER_ON_REQ, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_power_on_req_t;

/*
 *  SL_LINK_CONGESTED_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_timestamp;
    sl_ulong    sl_cong_level;  /* status  level */
    sl_ulong    sl_disc_level;  /* discard level */
} sl_link_cong_ind_t;

/*
 *  SL_LINK_CONGESTION_CEASED_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_timestamp;
    sl_ulong    sl_cong_level;  /* status  level */
    sl_ulong    sl_disc_level;  /* discard level */
} sl_link_cong_ceased_ind_t;

/*
 *  SL_RETRIEVED_MESSAGE_IND, M_PROTO or M_PCPROTO type with M_DATA block(s)
 */
typedef struct {
    sl_long     sl_primitive;
} sl_retrieved_msg_ind_t;

/*
 *  SL_RETRIEVAL_COMPLETE_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_retrieval_comp_ind_t;

/*
 *  SL_RB_CLEARED_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_rb_cleared_ind_t;

/*
 *  SL_BSNT_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_bsnt;
} sl_bsnt_ind_t;

/*
 *  SL_IN_SERVICE_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_in_service_ind_t;

/*
 *  SL_OUT_OF_SERVICE_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_timestamp;
    sl_ulong    sl_reason;
} sl_out_of_service_ind_t;

/*
 *  These reasons for failure as so that upstream module can
 *  collect statistics per link per ITU-T Q.752 Table 1
 *  requirements.
 */
#define SL_FAIL_UNSPECIFIED             0x0001
#define SL_FAIL_CONG_TIMEOUT            0x0002
#define SL_FAIL_ACK_TIMEOUT             0x0004
#define SL_FAIL_ABNORMAL_BSNR           0x0008
#define SL_FAIL_ABNORMAL_FIBR           0x0010
#define SL_FAIL_SUERM_EIM               0x0020
#define SL_FAIL_ALIGNMENT_NOT_POSSIBLE  0x0040
#define SL_FAIL_RECEIVED_SIO            0x0080
#define SL_FAIL_RECEIVED_SIN            0x0100
#define SL_FAIL_RECEIVED_SIE            0x0200
#define SL_FAIL_RECEIVED_SIOS           0x0400
#define SL_FAIL_T1_TIMEOUT              0x0800

/*
 *  SL_REMOTE_PROCESSOR_OUTAGE_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_timestamp;
} sl_rem_proc_out_ind_t;

/*
 *  SL_REMOTE_PROCESSOR_RECOVERED_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
    sl_ulong    sl_timestamp;
} sl_rem_proc_recovered_ind_t;

/*
 *  SL_RTB_CLEARED_IND, M_PROTO or M_PCPROTO type
 */
typedef struct {
    sl_long     sl_primitive;
} sl_rtb_cleared_ind_t;

/*
 *  Generic single argument type
 */
typedef struct {
    sl_ulong    sl_cmd;
    sl_ulong    sl_arg;
} sl_cmd_arg_t;

/*
 *  Generic double argument type
 */
typedef struct {
    sl_ulong    sl_cmd;
    sl_ulong    sl_arg1;
    sl_ulong    sl_arg2;
} sl_cmd_2arg_t;

/*
 *  Generic triple argument type
 */
typedef struct {
    sl_ulong    sl_cmd;
    sl_ulong    sl_arg1;
    sl_ulong    sl_arg2;
    sl_ulong    sl_arg3;
} sl_cmd_3arg_t;


union SL_primitives {
    sl_long                     sl_primitive;
    sl_cmd_arg_t                cmd_arg;
    sl_cmd_2arg_t               cmd_2arg;
    sl_cmd_3arg_t               cmd_3arg;
    sl_pdu_req_t                pdu_req;
    sl_pdu_ind_t                pdu_ind;
    sl_emergency_req_t          emergency_req;
    sl_emergency_ceases_req_t   emergency_ceases_req;
    sl_start_req_t              start_req;
    sl_stop_req_t               stop_req;
    sl_retrieve_bsnt_req_t      retrieve_bsnt_req;
    sl_retrieval_req_and_fsnc_t retrieval_req_and_fsnc;
    sl_resume_req_t             resume_req;
    sl_clear_buffers_req_t      clear_buffers_req;
    sl_local_proc_outage_req_t  local_proc_outage_req;
    sl_cong_discard_req_t       cong_discard_req;
    sl_cong_accept_req_t        cong_accept_req;
    sl_no_cong_req_t            no_cong_req;
    sl_power_on_req_t           power_on_req;
    sl_link_cong_ind_t          link_cong_ind;
    sl_link_cong_ceased_ind_t   link_cong_ceased_ind;
    sl_retrieved_msg_ind_t      retrieved_msg_ind;
    sl_retrieval_comp_ind_t     retrieval_comp_ind;
    sl_rb_cleared_ind_t         rb_cleared_ind;
    sl_bsnt_ind_t               bsnt_ind;
    sl_in_service_ind_t         in_service_ind;
    sl_out_of_service_ind_t     out_of_service_ind;
    sl_rem_proc_out_ind_t       rem_proc_out_ind;
    sl_rem_proc_recovered_ind_t rem_proc_recovered_ind;
    sl_rtb_cleared_ind_t        rtb_cleared_ind;
};

#define SL_CMD_ARG_SIZE                 sizeof(sl_cmd_arg_t)
#define SL_CMD_2ARG_SIZE                sizeof(sl_cmd_2arg_t)
#define SL_CMD_3ARG_SIZE                sizeof(sl_cmd_3arg_t)
#define SL_PDU_REQ_SIZE                 sizeof(sl_pdu_req_t)
#define SL_PDU_IND_SIZE                 sizeof(sl_pdu_ind_t)
#define SL_EMERGENCY_REQ_SIZE           sizeof(sl_emergency_req_t)
#define SL_EMERGENCY_CEASES_REQ_SIZE    sizeof(sl_emergency_ceases_req_t)
#define SL_START_REQ_SIZE               sizeof(sl_start_req_t)
#define SL_STOP_REQ_SIZE                sizeof(sl_stop_req_t)
#define SL_RETRIEVE_BSNT_REQ_SIZE       sizeof(sl_retrieve_bsnt_req_t)
#define SL_RETRIEVAL_REQ_AND_FSNC_SIZE  sizeof(sl_retrieval_req_and_fsnc_t)
#define SL_RESUME_REQ_SIZE              sizeof(sl_resume_req_t)
#define SL_CLEAR_BUFFERS_REQ_SIZE       sizeof(sl_clear_buffers_req_t)
#define SL_LOCAL_PROC_OUTAGE_REQ_SIZE   sizeof(sl_local_proc_outage_req_t)
#define SL_CONG_DISCARD_REQ_SIZE        sizeof(sl_cong_discard_req_t)
#define SL_CONG_ACCEPT_REQ_SIZE         sizeof(sl_cong_accept_req_t)
#define SL_NO_CONG_REQ_SIZE             sizeof(sl_no_cong_req_t)
#define SL_POWER_ON_REQ_SIZE            sizeof(sl_power_on_req_t)
#define SL_LINK_CONG_IND_SIZE           sizeof(sl_link_cong_ind_t)
#define SL_LINK_CONG_CEASED_IND_SIZE    sizeof(sl_link_cong_ceased_ind_t)
#define SL_RETRIEVED_MSG_IND_SIZE       sizeof(sl_retrieved_msg_ind_t)
#define SL_RETRIEVAL_COMP_IND_SIZE      sizeof(sl_retrieval_comp_ind_t)
#define SL_RB_CLEARED_IND_SIZE          sizeof(sl_rb_cleared_ind_t)
#define SL_BSNT_IND_SIZE                sizeof(sl_bsnt_ind_t)
#define SL_IN_SERVICE_IND_SIZE          sizeof(sl_in_service_ind_t)
#define SL_OUT_OF_SERVICE_SIZE          sizeof(sl_out_of_service_ind_t)
#define SL_REM_PROC_OUT_IND_SIZE        sizeof(sl_rem_proc_out_ind_t)
#define SL_REM_PROC_RECOVERED_IND_SIZE  sizeof(sl_rem_proc_recovered_ind_t)
#define SL_RTB_CLEARED_IND_SIZE         sizeof(sl_rtb_cleared_ind_t)

#endif  __SS7_SLI_H__

