/*****************************************************************************

 @(#) $Id: slsi_ioctl.h,v 0.7.4.1 2001/02/18 09:44:44 brian Exp $

 -----------------------------------------------------------------------------

 Copyright (C) 1997-2001  Brian Bidulock <bidulock@dallas.net>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; either version 2 of the License, or (at your option) any later
 version.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 Last Modified $Date: 2001/02/18 09:44:44 $ by $Author: brian $

 *****************************************************************************/

#ifndef __SLSI_IOCTL_H__
#define __SLSI_IOCTL_H__

#include <linux/ioctl.h>

/*
 *  FIXME: these definitions are completely bogus right now....
 */

#define LS_IOC_MAGIC 'S'

/*
 *  PROTOCOL VARIANT AND OPTIONS
 */

#define LS_IOCGOPTIONS _IOR(  LS_IOC_MAGIC, 0, lmi_option_t )
#define LS_IOCSOPTIONS _IOW(  LS_IOC_MAGIC, 1, lmi_option_t )

/*
 *  CONFIGURATION
 */
typedef struct ls_config {
    ls_ulong    apc;    /* adjacent point code */
    ls_ulong    lpc;    /* local    point code */
    ls_uchar    ni;     /* network indicator for this linkset */
    ls_ulong    links_specified;
} ls_config_t;

#define LS_IOCGCONFIG  _IOWR( LS_IOC_MAGIC, 2, ls_config_t )
#define LS_IOCSCONFIG  _IOWR( LS_IOC_MAGIC, 3, ls_config_t )
#define LS_IOCTCONFIG  _IOWR( LS_IOC_MAGIC, 4, ls_config_t )
#define LS_IOCCCONFIG  _IOWR( LS_IOC_MAGIC, 5, ls_config_t )

/*
 *  STATE
 */

typedef struct ls_statem {
    ls_ulong    llsc_state;
    ls_ulong    links_active;
    ls_ulong    links_specified;
    ls_ulong    links_available;
    ls_ulong    own_sp_restart;
    ls_ulong    cong_status;    /* cong status for this link set */
    ls_ulong    disc_status;    /* disc status for this link set */
    ls_ulong    adjacent_sp_restart;
} ls_statem_t;

#define LS_STATE_INACTIVE   0
#define LS_STATE_ACTIVE     1

#define LS_IOCGSTATEM  _IOR(  LS_IOC_MAGIC, 6, ls_statem_t )
#define LS_IOCCMRESET  _IOR(  LS_IOC_MAGIC, 7, ls_statem_t )

/*
 *  -----------------------------------------------------------------------
 *
 *  STATISTICS
 *
 *  -----------------------------------------------------------------------
 */

typedef struct ls_stats {
    lmi_sta_t   header;
} ls_stats_t;
                                            /* FIXME: read 3.11 and recheck congestion procedures */

#define LS_IOCGSTATSP  _IOR(  LS_IOC_MAGIC,  8, lmi_sta_t )
#define LS_IOCSSTATSP  _IORW( LS_IOC_MAGIC,  9, lmi_sta_t )
#define LS_IOCGSTATS   _IOR(  LS_IOC_MAGIC, 10, ls_stats_t )
#define LS_IOCCSTATS   _IOW(  LS_IOC_MAGIC, 11, ls_stats_t )

/*
 *  NOTIFICATIONS
 */

typedef struct ls_notify {
    ls_ulong    events;
} ls_notify_t;

#define LS_EVENT_HEADER_LEN         16  /* for now */

#define LS_EVT_FAIL_UNSPECIFIED   LS_FAIL_UNSPECIFIED
#define LS_EVT_FAIL_CONG_TIMEOUT  LS_FAIL_CONG_TIMEOUT      /* Q.752 Table 1.6 */
#define LS_EVT_FAIL_ACK_TIMEOUT   LS_FAIL_ACK_TIMEOUT       /* Q.752 Table 1.4 */
#define LS_EVT_FAIL_ABNORMAL_BSNR LS_FAIL_ABNORMAL_BSNR
#define LS_EVT_FAIL_ABNORMAL_FIBR LS_FAIL_ABNORMAL_FIBR
#define LS_EVT_FAIL_ABORMAL       LS_FAIL_ABNORMAL_BSNR | \
                                  LS_FAIL_ABNORMAL_FIBR     /* Q.752 Table 1.3 */
#define LS_EVT_FAIL_SUERM_EIM     LS_FAIL_SUERM_EIM         /* Q.752 Table 1.5 */
#define LS_EVT_FAIL_ALIGNMENT     LS_FAIL_ASLIGNMENT_NOT_POSSIBLE
#define LS_EVT_FAIL_RECEIVED_SIO  LS_FAIL_RECEIVED_SIO
#define LS_EVT_FAIL_RECEIVED_SIN  LS_FAIL_RECEIVED_SIN
#define LS_EVT_FAIL_RECEIVED_SIE  LS_FAIL_RECEIVED_SIE
#define LS_EVT_FAIL_RECEIVED_SIOS LS_FAIL_RECEIVED_SIOS
#define LS_EVT_FAIL_T1_TIMEOUT    LS_FAIL_T1_TIMEOUT
#define LS_EVT_RPO_BEGIN          LS_FAIL_T1_TIMEOUT      <<1 /* Q.752 Table 2.10 */
#define LS_EVT_RPO_END            LS_EVT_RPO_BEGIN        <<1 /* Q.752 Table 2.11 */
#define LS_EVT_CONGEST_ONSET_IND  LS_EVT_RPO_END          <<1 /* Q.752 Table 3.6  1st&D */
#define LS_EVT_CONGEST_DISCD_IND  LS_EVT_CONGEST_ONSET_IND<<1 /* Q.752 Table 3.11 1st&D */

#define LS_EVT_FAIL_ALL_REASONS   LS_FAIL_UNSPECIFIED \
                                 |LS_FAIL_CONG_TIMEOUT \
                                 |LS_FAIL_ACK_TIMEOUT  \
                                 |LS_FAIL_ABNORMAL_FIBR \
                                 |LS_FAIL_ABNORMAL_BSNR \
                                 |LS_FAIL_SUERM_EIM \
                                 |LS_FAIL_ALIGNMENT_NOT_POSSIBLE \
                                 |LS_FAIL_RECEIVED_SIO \
                                 |LS_FAIL_RECEIVED_SIN \
                                 |LS_FAIL_RECEIVED_SIE \
                                 |LS_FAIL_RECEIVED_SIOS \
                                 |LS_FAIL_T1_TIMEOUT          /* Q.752 Table 1.2 */

#define LS_IOCGNOTIFY  _IOR(  LS_IOC_MAGIC, 12, ls_notify_t )
#define LS_IOCSNOTIFY  _IOW(  LS_IOC_MAGIC, 13, ls_notify_t )
#define LS_IOCCNOTIFY  _IOW(  LS_IOC_MAGIC, 14, ls_notify_t )

#define LS_IOC_FIRST     0
#define LS_IOC_LAST     14
#define LS_IOC_PRIVATE  32




#define LK_IOC_MAGIC 'S'

/*
 *  PROTOCOL VARIANT AND OPTIONS
 */

#define LK_IOCGOPTIONS _IOR(  LK_IOC_MAGIC, 0, lmi_option_t )
#define LK_IOCSOPTIONS _IOW(  LK_IOC_MAGIC, 1, lmi_option_t )

/*
 *  CONFIGURATION
 */
typedef struct lk_config {
    lk_ulong    slc;    /* signalling link code         */
    lk_ulong    tt1;
    lk_ulong    tt2;
    lk_ulong    t1;
    lk_ulong    t2;
    lk_ulong    t3;
    lk_ulong    t4;
    lk_ulong    t5;
    lk_ulong    t7;
    lk_ulong    t12;
    lk_ulong    t13;
    lk_ulong    t14;
    lk_ulong    t17;
    lk_ulong    t22;
    lk_ulong    t23;
    lk_ulong    t24;
    lk_ulong    terminal_predetermined;
    lk_ulong    data_link_predetermined;
} lk_config_t;

#define LK_IOCGCONFIG  _IOWR( LK_IOC_MAGIC, 2, lk_config_t )
#define LK_IOCSCONFIG  _IOWR( LK_IOC_MAGIC, 3, lk_config_t )
#define LK_IOCTCONFIG  _IOWR( LK_IOC_MAGIC, 4, lk_config_t )
#define LK_IOCCCONFIG  _IOWR( LK_IOC_MAGIC, 5, lk_config_t )

/*
 *  STATE
 */

typedef struct lk_statem {
    lk_ulong    sltc_state;
    lk_uchar        tli;        /* test length indicator for test messages */
    lk_uchar        tmsx[15];   /* test pattern for test messages */
    lk_ulong    lsla_state;
    lk_ulong    lsac_state;
    lk_ulong        terminal_determined;
    lk_ulong        data_link_determined;
    lk_ulong        activation;
    lk_ulong        activation_restoration_unsuccessful;
    lk_ulong        emergency;
    lk_ulong        local_processor_outage;
    lk_ulong        first_failure;
    lk_ulong    lslr_state;
    lk_ulong        replace_terminal;
    lk_ulong        replace_data_link;
    lk_ulong        restoration;
    lk_ulong    lsta_state;
    lk_ulong        terminal_idle;
    lk_ulong        terminal_available;
    lk_ulong    lsda_state;
    lk_ulong        sdli;   /* signalling data link id  ??? */ /* FIXME */
    lk_ulong        data_link_available;
    lk_ulong    llsc_state;
    lk_ulong    tlac_state;
    lk_ulong        local_inhibit_in_progress;
    lk_ulong        uninhibit_in_progress;
    lk_ulong        changeover_in_progress;
    lk_ulong        changeover_order;
    lk_ulong        emergency_changeover_order;
    lk_ulong        changeback_in_progress;
    lk_ulong        changeback_required;
    lk_ulong        local_blocked;
    lk_ulong        remote_blocked;
    lk_ulong        locally_inhibited;
    lk_ulong        remotely_inhibited;
    lk_ulong        failed;
    lk_ulong        management_request;
    lk_ulong        second_time_t12_expires;
    lk_ulong        second_time_t13_expires;
    lk_ulong        unavailable;
    lk_ulong    tcbc_state;
    lk_ulong        cbc;
    lk_ulong        routing_changed;        /* ?? */
    lk_ulong        remote_sp_accessible;   /* ?? */
    lk_ulong    tcoc_state;
    lk_ulong        retrieval_required;     /* ?? */
    lk_ulong        changeover_possible;    /* ?? */
    lk_ulong        fsnc;
    lk_ulong        remote_bsnt_retrieved;
    lk_ulong        bsnt;
    lk_ulong        local_bsnt_retrieved;
    lk_ulong    flags;          /* flags for this link                  */
    lk_ulong    cob_state;      /* chanveover/back state                */
    lk_ulong    cong_status;    /* congest status of this link          */
    lk_ulong    disc_status;    /* discard status of this link          */
    lk_ulong    loc_bsnt;       /* local  retrieved bsnt                */
    lk_ulong    rem_bsnt;       /* remote retrieved bsnt                */
    lk_ulong    cob_reason;     /* changeover cancel changeback reason  */
    mblk_t      *msg;           /* message holder for changeover order  */
    bufq_t      cocbb;          /* changeover/changeback buffer         */
    bufq_t      rtrvb;          /* retrieval buffer                     */
} lk_statem_t;

#define LK_FLAG_OUT_OF_SERVICE  0x0001  /* link is out of service               */
#define LK_FLAG_INACTIVE        0x0002  /* link has not been activated          */
#define LK_FLAG_LOCAL_INHIBIT   0x0004  /* link has been inhibited locally      */
#define LK_FLAG_REMOTE_INHIBIT  0x0008  /* link has been inhibited remotely     */
#define LK_FLAG_CONGESTED       0x0010  /* link is congested                    */
#define LK_FLAG_BLOCKED         0x0020  /* link is blocked (remote proc outage) */
#define LK_FLAG_CHANGEOVER      0x0040  /* performing changeover on this link   */
#define LK_FLAG_CHANGEBACK      0x0080  /* performing changeback on this link   */
#define LK_FLAG_TEST            0x0100  /* first  SLT                           */
#define LK_FLAG_RETEST          0x0200  /* second SLT                           */

#define LK_MASK_DONTUSE         0x000f  /* this link is unusable                */

#define LK_COB_IDLE             0   /* no changeover/back in progress   */
#define LK_COB_BSNT_REQ_COO     1   /* no changeover/back in progress   */
#define LK_COB_BSNT_REQ_COA     2   /* no changeover/back in progress   */
#define LK_COB_TIME_CONTROLLED  3   /* no changeover/back in progress   */
#define LK_COB_WAITING_ACK      4   /* no changeover/back in progress   */
#define LK_COB_RETRIEVING       5   /* no changeover/back in progress   */

#define LK_STATE_IDLE                       0
#define LK_STATE_INACTIVE                   0
#define LK_STATE_UNAVAILABLE                0    /* tlac */
#define LK_STATE_ACTIVE                     1
#define LK_STATE_WAIT                       2
#define LK_STATE_ACTIVATING_RESTORING       3
#define LK_STATE_FAILED                     4
#define LK_STATE_WAIT_FOR_DATA_LINK         5
#define LK_STATE_WAIT_FOR_TERMINAL          6
#define LK_STATE_WAITING                    7
#define LK_STATE_WAITING_FOR_CONNECTION     8
#define LK_STATE_AVAILABLE                  9   /* tlac */
#define LK_STATE_SP_RESTARTING              10  /* tlac */
#define LK_STATE_1ST_ATTEMPT                11  /* sltc */
#define LK_STATE_2ND_ATTEMPT                12  /* sltc */
#define LK_STATE_TIME_CONTROLLED_DIVERSION  13  /* tcbc */
#define LK_STATE_FIRST_ATTEMPT              14  /* tcbc */
#define LK_STATE_SECOND_ATTEMPT             15  /* tcbc */
#define LK_STATE_WAIT_FOR_ROUTING_DATA      16  /* tcbc */
#define LK_STATE_WAIT01                     17  /* tcoc */
#define LK_STATE_WAIT02                     18  /* tcoc */
#define LK_STATE_WAIT05                     19  /* tcoc */
#define LK_STATE_WAIT06                     20  /* tcoc */
#define LK_STATE_WAIT07                     21  /* tcoc */
#define LK_STATE_RETRIEVING                 22  /* tcoc */
#define LK_STATE_WAIT_FOR_ACKNOWLEDGEMENT   23  /* tcoc */

#define LK_IOCGSTATEM  _IOR(  LK_IOC_MAGIC, 6, lk_statem_t )
#define LK_IOCCMRESET  _IOR(  LK_IOC_MAGIC, 7, lk_statem_t )

/*
 *  -----------------------------------------------------------------------
 *
 *  STATISTICS
 *
 *  -----------------------------------------------------------------------
 */

typedef struct lk_stats {
    lmi_sta_t   header;
/**/ls_ulong    lk_dur_in_service;          /* Q.752 Table 1.1    30 min */ 
    ls_ulong    lk_fail_align_or_proving;   /* Q.752 Table 1.7  5,30 min */
    ls_ulong    lk_nacks_received;          /* Q.752 Table 1.9  5,30 min */
    ls_ulong    lk_dur_unavail;             /* Q.752 Table 2.1    30 min */
    ls_ulong    lk_dur_unavail_failed;      /* Q.752 Table 2.7    30 min */
    ls_ulong    lk_dur_unavail_rpo;         /* Q.752 Table 2.9    30 min */
    ls_ulong    lk_sibs_sent;               /* Q.752 Table 2.15 5,30 min */
    ls_ulong    lk_tran_sio_sif_octets;     /* Q.752 Table 3.1  5,30 min */ /* trasmitted first time */
    ls_ulong    lk_retrans_octets;          /* Q.752 Table 3.2  5,30 min */ /* includes opening flag and crc */
    ls_ulong    lk_tran_msus;               /* Q.752 Table 3.3  5,30 min */ /* transmitted first time */
    ls_ulong    lk_recv_sio_sif_octets;     /* Q.752 Table 3.4  5,30 min */
    ls_ulong    lk_recv_msus;               /* Q.752 Table 3.5  5,30 min */ /* passed to L3 */
    ls_ulong    lk_cong_onset_ind[4];       /* Q.752 Table 3.6  5,30 min */ /* and 3.9 */
    ls_ulong    lk_dur_cong_level[4];       /* Q.752 Table 3.7    30 min */ /* rising only */
/*  ls_ulong    lk_msus_cong_discard;          Q.752 Table 3.10 5,30 min */ /* Not here in MTP or SLS */
    ls_ulong    lk_cong_discd_ind[4];       /* Q.752 Table 3.11 5,30 min */ /* rising only when < onset */
} lk_stats_t;
                                            /* FIXME: read 3.11 and recheck congestion procedures */

#define LK_IOCGSTATSP  _IOR(  LK_IOC_MAGIC,  8, lmi_sta_t )
#define LK_IOCSSTATSP  _IORW( LK_IOC_MAGIC,  9, lmi_sta_t )
#define LK_IOCGSTATS   _IOR(  LK_IOC_MAGIC, 10, lk_stats_t )
#define LK_IOCCSTATS   _IOW(  LK_IOC_MAGIC, 11, lk_stats_t )

/*
 *  NOTIFICATIONS
 */

typedef struct lk_notify {
    ls_ulong    events;
} lk_notify_t;

#define LK_EVENT_HEADER_LEN         16  /* for now */

#define LK_EVT_FAIL_UNSPECIFIED   LK_FAIL_UNSPECIFIED
#define LK_EVT_FAIL_CONG_TIMEOUT  LK_FAIL_CONG_TIMEOUT      /* Q.752 Table 1.6 */
#define LK_EVT_FAIL_ACK_TIMEOUT   LK_FAIL_ACK_TIMEOUT       /* Q.752 Table 1.4 */
#define LK_EVT_FAIL_ABNORMAL_BSNR LK_FAIL_ABNORMAL_BSNR
#define LK_EVT_FAIL_ABNORMAL_FIBR LK_FAIL_ABNORMAL_FIBR
#define LK_EVT_FAIL_ABORMAL       LK_FAIL_ABNORMAL_BSNR | \
                                  LK_FAIL_ABNORMAL_FIBR     /* Q.752 Table 1.3 */
#define LK_EVT_FAIL_SUERM_EIM     LK_FAIL_SUERM_EIM         /* Q.752 Table 1.5 */
#define LK_EVT_FAIL_ALIGNMENT     LK_FAIL_ASLIGNMENT_NOT_POSSIBLE
#define LK_EVT_FAIL_RECEIVED_SIO  LK_FAIL_RECEIVED_SIO
#define LK_EVT_FAIL_RECEIVED_SIN  LK_FAIL_RECEIVED_SIN
#define LK_EVT_FAIL_RECEIVED_SIE  LK_FAIL_RECEIVED_SIE
#define LK_EVT_FAIL_RECEIVED_SIOS LK_FAIL_RECEIVED_SIOS
#define LK_EVT_FAIL_T1_TIMEOUT    LK_FAIL_T1_TIMEOUT
#define LK_EVT_RPO_BEGIN          LK_FAIL_T1_TIMEOUT      <<1 /* Q.752 Table 2.10 */
#define LK_EVT_RPO_END            LK_EVT_RPO_BEGIN        <<1 /* Q.752 Table 2.11 */
#define LK_EVT_CONGEST_ONSET_IND  LK_EVT_RPO_END          <<1 /* Q.752 Table 3.6  1st&D */
#define LK_EVT_CONGEST_DISCD_IND  LK_EVT_CONGEST_ONSET_IND<<1 /* Q.752 Table 3.11 1st&D */

#define LK_EVT_FAIL_ALL_REASONS   LK_FAIL_UNSPECIFIED \
                                 |LK_FAIL_CONG_TIMEOUT \
                                 |LK_FAIL_ACK_TIMEOUT  \
                                 |LK_FAIL_ABNORMAL_FIBR \
                                 |LK_FAIL_ABNORMAL_BSNR \
                                 |LK_FAIL_SUERM_EIM \
                                 |LK_FAIL_ALIGNMENT_NOT_POSSIBLE \
                                 |LK_FAIL_RECEIVED_SIO \
                                 |LK_FAIL_RECEIVED_SIN \
                                 |LK_FAIL_RECEIVED_SIE \
                                 |LK_FAIL_RECEIVED_SIOS \
                                 |LK_FAIL_T1_TIMEOUT          /* Q.752 Table 1.2 */

#define LK_IOCGNOTIFY  _IOR(  LK_IOC_MAGIC, 12, lk_notify_t )
#define LK_IOCSNOTIFY  _IOW(  LK_IOC_MAGIC, 13, lk_notify_t )
#define LK_IOCCNOTIFY  _IOW(  LK_IOC_MAGIC, 14, lk_notify_t )

#define LK_IOC_FIRST     0
#define LK_IOC_LAST     14
#define LK_IOC_PRIVATE  32



#endif  __SLSI_IOCTL_H__
